function M=MasseBeam3(m,L,I_A)

% Forme la matrice de masse lmentaire K d'un lment de poutre  2
% noeuds et 3 ddl par noeud (dpl axial, dpl transversal, rotation)
%
% ELEMENT A 6 DEGRES DE LIBERTE
% ------------------------------
% m : masse linique
% L   : Longueur de l'lment
% I_A : rapport I/A (m^2), optionnel
%
%   DDL | Effort
%  -----+--------
%    1  | Noeud 1 : effort axial
%    2  | Noeud 1 : effort tranchant
%    3  | Noeud 1 : moment de flexion
%    4  | Noeud 2 : effort axial
%    5  | Noeud 2 : effort tranchant
%    6  | Noeud 2 : moment de flexion

V=m*L/420;
A=m*L/6;


M=[ 2*A      0        0      A       0       0     ;
    0     156*V    22*V*L    0     54*V    -13*V*L ;
    0     22*V*L  4*V*L^2    0    13*V*L  -3*V*L^2 ;
    A       0        0     2*A      0       0      ;
    0     54*V    13*V*L     0    156*V   -22*V*L  ;
    0   -13*V*L -3*V*L^2     0   -22*V*L  4*V*L^2  ];

% M=[ 3*A     0       0      A       0       0 ;
%     0      3*A      0      0       0       0 ;
%     0       0       0      0       0       0 ;
%     A       0       0     3*A      0       0 ;
%     0       0       0      0     3*A       0 ;
%     0       0       0      0       0       0  ];

if nargin >=3
    M2=[  0        0        0      0       0       0     ;
        0      6/5       L/10    0     -6/5    L/10    ;
        0      L/10  2*L^2/15    0     -L/10  -L^2/30  ;
        0       0        0       0      0       0      ;
        0     -6/5    -L/10      0      6/5   -L/10    ;
        0      L/10  -L^2/30     0     -L/10  2*L^2/15];
    M = M + M2*m/L*I_A;
end
