function [X, Y, NPTS, SURF, NpSURF,NELM, SizeELM] = MaillageBase2MDDL2(M,N);
% [X, Y, NPTS, SURF, NpSURF,NELM, SizeELM] = MaillageBase2MDDL2(M,N);
% Ralisation d'un maillage de base pour intgration d'un bispectre
% M = pulse maximum
% N = nombre de subdivisions entre 0 et M
%
% 1.- Le domaine d'intgration est le compact [-M,M]x[-M,M]
% 2.- Ce domaine est divis en rgions lmentaires (carrs) de dimensions DMAX = 2M/N

% POSITION DES POINTS D'INTEGRATION ELEMENTAIRES
NPTS = 0; DMAX = 2*M/N;
for i=1:N/2+1
    for j=1:N+1
        NPTS = NPTS + 1;
        X(NPTS) = M - (i-1)*DMAX;
        Y(NPTS) = M - (j-1)*DMAX;
    end
end


% CREATION DES SURFACES D'INTEGRATION ELEMENTAIRES
NELM = 0;
for i=1:N/2
    for j=1:N
        NELM = NELM +1;
        SURF(NELM,1)= (N+1)*i+j;
        SURF(NELM,2)= (N+1)*(i-1)+j;
        SURF(NELM,3)= (N+1)*(i-1)+j+1;
        SURF(NELM,4)= (N+1)*i+j+1;
        NpSURF(NELM)=4;
        SizeELM(NELM) = DMAX;
    end
end

