function [M3Q, B, BR, TR, BRij, BRik, BRjk] = MTSA_bicorr(Bf,m3f,k_ijk, w_ijk, xi_ijk, w)
%
% Bf = function handle to Bf(w1,w2)

[w_ijk, order] = sort(w_ijk);
xi_ijk = xi_ijk(order);

wi = w_ijk(1); xi = xi_ijk(1);
wj = w_ijk(2); xj = xi_ijk(2);
wk = w_ijk(3); xk = xi_ijk(3);

K3 = prod(k_ijk);

wjk = (wj+wk)/2;
wik = (wi+wk)/2;
wij = (wi+wj)/2;

int_jk = Bf(w,wjk) ./ ( wjk*(xj+xk) + 1i * (wk-wj-w));
BRjk   = pi * wjk^2 / K3 * trapz(w,int_jk);

int_ik = Bf(wik,w) ./ ( wik*(xi+xk) + 1i * (wk-wi-w));
BRik   = pi * wik^2 / K3 * trapz(w,int_ik);

int_ij = Bf(-wij+w/2,wij+w/2) ./  ( wij*(xi+xj) +  1i * (w-wj+wi));
BRij   = pi*wij^2 / K3 * trapz(w,int_ij);

% background, biresonant, triresonant
B  =  m3f /K3;
BR =  BRij + BRik + BRjk;
TR =  -2/K3 * Bf(wi,wj)*pi^2/2*wi*wj*(wk-wi-wj)*(wi+wj)/((wk-wi-wj)^2+(wi*(xi+xk)+wj*(xj+xk))^2);

M3Q= B + BR + TR; 

%figure(777), plot(w,real(int_ij ),  w,real(int_ik), w,real(int_jk)), legend ('ij','ik','jk')

% %%
% keyboard
% 
%  wi=1;
% wj=1.1;
% wk = 3;
% 
% [w1,w2] = meshgrid(-2:0.05:2);
% Kapprox_ij = -1i*wi*wj*(wi+wj) ./ ( 8 * (w1+(-1-1i*xi)*wi) * (1i*w2+(-1i+xj)*wj) .* (w1+w2+1i*xk*(wi+wj)-wk))
% 
% H1 = 1 ./ (1-(w1/wi).^2+2*1i*(w1/wi)*xi);
% H2 = 1 ./ (1-(w2/wj).^2+2*1i*(w2/wj)*xj);
% H3 = 1 ./ (1-((w1+w2)/wk).^2-2*1i*((w1+w2)/wk)*xk);
% Kexact = H1.*H2.*H3;


