function f = FrequencesDeCalculFctTransfert(ksi,fn)
% f = FrequencesDeCalculFctTransfert(ksi,fn)
% Renvoie un vecteur avec 103 frquences de calcul de fonction de transfert
% caractrise par un taux d'amort ksi et une frqu. propre fn
%
% V. Denoel juin 2004
% 
% SEE ALSO : FrequencesDeCalcul(KSI,FN,fsoll)

n= 50;

% Avant le pic
A = (1.32-7.1*ksi)*1E-2;
B = 0.5; 
C = -B*n/2;
D = 1/n * (sqrt(1-ksi^2)-A/B * ((C+B*n)*atan(C+B*n)-0.5*log((1+(C+B*n)^2)/(1+C^2))-C*atan(C))); %Formule (3.141)
i=0:n;
w = D*i + A/B * ((C+B*i).*atan(C+B*i)-0.5*log((1+(C+B*i).^2)/(1+C^2))-C*atan(C)); %Formule (3.138)
f=sqrt(1-ksi^2)-w;
finflex = 1 - sqrt(3)/3*ksi + 17/18*ksi^2;
f= sort([f finflex]); f(1)=0;

% Aprs le pic
A = (26.8-90*ksi)*1E-3;
B = 0.5; 
C = -B*n/2;
D = 1/n * (3-sqrt(1-ksi^2)-A/B * ((C+B*n)*atan(C+B*n)-0.5*log((1+(C+B*n)^2)/(1+C^2))-C*atan(C)));
i=1:n;
w = sqrt(1-ksi^2) + D*i + A/B * ((C+B*i).*atan(C+B*i)-0.5*log((1+(C+B*i).^2)/(1+C^2))-C*atan(C));
finflex = 1 + sqrt(3)/3*ksi + 17/18*ksi^2;
f= sort([f w finflex]) * fn;