function f = FrequencesDeCalcul(ksi,fn,fsoll)
% f = FrequencesDeCalcul(ksi,fn,fsoll)
%
% Le vecteur f contient les frquences de calcul pour l'analyse d'une
% structure MDDL dont les frquences naturelles sont comprises dans fn et
% les amortissements modaux dans ksi. les frequences ncessaires  la bonne
% reprsentation de l'effort sont dans fsoll (calcul par ailleurs).
%
% SEE ALSO : FrequencesDeCalculTransfert (rpartit les frquences pour 1DDL)
%            FrequenceDefinitionVent (pour tablir fsoll, par exemple)

if nargin <3 ;  k = 3; end

Nmod = length(fn);
F = [];
for Mode = 1:Nmod%+1
    if Mode ~= Nmod + 1 
        f = FrequencesDeCalculFctTransfert(ksi(Mode),fn(Mode)); N = 103;
    else
        f=fsoll; N = length(f);
    end
    Nf(Mode) = N;
    F=[F f];
    for i = 1:N-1
        DF(i,Mode) = f(i+1)-f(i);
        fr(i,Mode) = f(i);
    end
    DF(1,Mode)=DF(2,Mode);
    DF(N-1,Mode)=DF(N-2,Mode);
    fr(N,Mode) = f(N);
%    figure(1);subplot(2,2,1);plot(f(1:N-1),DF(1:N-1,Mode),'k.-');hold on
%    subplot(2,2,3);plot(f(1:N-1),DF(1:N-1,Mode),'k:');hold on
    %figure(2);if Mode ~= Nmod+1; plot(f,1./((1-(f/fn(Mode)).^2).^2+(2*ksi(Mode)*f/fn(Mode)).^2),'b.-');hold on;end
end

L=length(F); 

% Calcul du mode dominant, c'est--dire, celui ayant le plus petit DF
F = sort(F);
for i=1:L
    df = 0;
    for Mode=1:Nmod%+1  % +1 pour traiter galement l'effort appliqu
        if max(fr(1:Nf(Mode)-1,Mode)) > F(i)
            DF_MODE = linterp(fr(1:Nf(Mode)-1,Mode),DF(1:Nf(Mode)-1,Mode),F(i));
            if df == 0
                df = DF_MODE;
                MODE = Mode;
            else
                if DF_MODE < df
                    df = DF_MODE;
                    MODE = Mode;
                end
            end
        end
    end
    Mode_Dominant(i) = MODE;
end
%figure(1);subplot(2,2,2);bar(F,Mode_Dominant,1)

% Calcul des frquences limites, sparant les modes dominants
Nlim = 1;
flim(Nlim)=0; 
Mode_Dom(Nlim)=Mode_Dominant(1);
i=1;
while i<L
    while i<L & Mode_Dominant(i) == Mode_Dominant(i+1)
        i=i+1;
    end
    if i<L
        Nlim=Nlim+1;
        flim(Nlim)=F(i+1);
        Mode_Dom(Nlim)=Mode_Dominant(i+1);
        i=i+1;
    end 
end
flim(Nlim+1) = max(F);

% Attribution des frquences entre frquences limites
Fc = [];
for i=1:Nlim
    MODE = Mode_Dom(i);
%    fmin = flim(i);
    if i == 1 ;
        fmin = 0;
    else
        fmin = Fc(length(Fc));
    end
    fmax=flim(i+1);
    ind1=1;
    while fr(ind1,MODE)<fmin
        ind1=ind1+1;
    end
    ind2=ind1;
    while fr(ind2,MODE)/fmax-1<-1E-10
        ind2=ind2+1;
    end
    Fc = [Fc fr(ind1:ind2,MODE)'];        
end

f = Fc;

%disp (['Economie sur le nombre de frquences : ' num2str(100*(1-length(f)/sum(Nf))) ' %'])


% Calcul du DF pour le plot; inutile en ralit !
%L = length(Fc);
%for i=1:L-1
% DFc(i) = Fc(i+1)-Fc(i);
%end
%figure(1);subplot(2,2,3);hold on;plot(Fc(1:L-1),DFc,'k','LineWidth',1.5)
%figure(1);subplot(2,2,4);bar(Fc)
