function [X, Y, SURF, NpSURF, SizeELM] = FrequencesBispectreMDDL3(FNAT, KSI, FSOLL)
   % [X,Y,SURF,NpSURF] = FrequencesBispectre(FNAT,KSI,FSOLL)
   % Dans DVAL, VAL et p : autant de lignes que de modes
   % Dans RAY, CENTREX, CENTREY et pR : 4 fois + de lignes que de modes
   

   FNAT_MAX = max(FNAT);
   FNAT_MIN = min(FNAT);
   M = 3 * FNAT_MAX;
   N = 10;
   
   % Réalisation du maillage de base
   [X, Y, NPTS, SURF, NpSURF, NELM, SizeELM] = MaillageBase2MDDL2(M, N);

   fprintf('\nStep 0:  %d  Zones.', size(SURF,1));
   
   RAYinit = [];
   PRinit = [];
   CENTREXinit=[];
   CENTREYinit=[];

   for imod = 1 : length(FNAT)

      if (FNAT(imod) ~= FNAT_MAX)

         r = FNAT(imod)/8;

         RAYinit = [RAYinit; FNAT(imod)*0.5; FNAT(imod)*0.5; FNAT(imod)*0.5; FNAT(imod)*0.5; ...
                  FNAT(imod)*0.5; FNAT(imod)*0.5; FNAT(imod)*0.5; FNAT(imod)*0.5; ...
                  FNAT(imod)*0.5; FNAT(imod)*0.5; FNAT(imod)*0.5; FNAT(imod)*0.5];

         PRinit = [PRinit; r; r; r; r; r; r; r; r; r; r; r; r;];

         CENTREXinit = [CENTREXinit; -2*FNAT(imod); -FNAT(imod); -FNAT(imod); -FNAT(imod); -FNAT(imod); ...
                  0; 0; FNAT(imod); FNAT(imod); FNAT(imod); FNAT(imod); 2*FNAT(imod)];

         CENTREYinit = [CENTREYinit; FNAT(imod); 2*FNAT(imod); FNAT(imod); 0; -FNAT(imod); FNAT(imod); -FNAT(imod); ...
                  FNAT(imod); 0; -FNAT(imod);- 2*FNAT(imod); -FNAT(imod)];
                  
         if (FNAT(imod) == FNAT_MIN)
            RAYinit     = [RAYinit; FNAT(imod)];
            PRinit      = [PRinit; r];
            CENTREXinit = [CENTREXinit; 0];
            CENTREYinit = [CENTREYinit; 0];
         end
      end
   end

   SUBDIV = SubDivision22(FNAT,[],[],RAYinit,CENTREXinit,CENTREYinit,PRinit,X,Y,SURF,NpSURF,SizeELM);
   
   %DessinMaillage(X,Y,NpSURF,SURF)
   [X, Y, SURF, NpSURF, SizeELM] = RafineMaillage2(X, Y, SURF, NpSURF, SizeELM, SUBDIV);
   

   fprintf('\nStep 0:  %d  Zones.', size(SURF,1));
   % DessinMaillage(X,Y,NpSURF,SURF)
   
   
   % Subdivisions nécessaires
   
   for imod = 1 : length(FNAT)

      DVAL(imod,1) = 0.08*FNAT(imod);
      p(imod,1)    = FNAT(imod)/12;

      DVAL(imod,2) = 0.05*FNAT(imod);
      p(imod,2)    = FNAT(imod)/20;

      DVAL(imod,3) = 0.03*FNAT(imod);
      p(imod,3)    = FNAT(imod)/30;

      if (KSI(imod) < 0.25)
         DVAL(imod,4) = 0.02*FNAT(imod);
         p(imod,4)    = FNAT(imod)/50;
      end
      if (KSI(imod) < 0.02)
         DVAL(imod,5) = 0.01*FNAT(imod);
         p(imod,5)    = FNAT(imod); % Bidon !
      end

      for ipic = 1 : 12

         RAY(12*imod-12+ipic,1) = 0.08*FNAT(imod);
         pR(12*imod-12+ipic,1)  = FNAT(imod)/8;

         RAY(12*imod-12+ipic,2) = 0.05*FNAT(imod);
         pR(12*imod-12+ipic,2)  = FNAT(imod)/20;

         RAY(12*imod-12+ipic,3) = 0.03*FNAT(imod);
         pR(12*imod-12+ipic,3)  = FNAT(imod)/40;

         if (KSI(imod) < 0.25)
            RAY(12*imod-12+ipic,4) = 0.02*FNAT(imod);
            pR(12*imod-12+ipic,4)  = FNAT(imod)/120;
         end
         if (KSI(imod) < 0.02)
            RAY(12*imod-12+ipic,5) = 0.01*FNAT(imod);
            pR(12*imod-12+ipic,5)  = FNAT(imod)/600;
         end
      end

      for subd = 1 : 5

         CENTREX(12*imod-12+1, subd)  = -2*FNAT(imod);
         CENTREY(12*imod-12+1, subd)  =   FNAT(imod);

         CENTREX(12*imod-12+2, subd)  =  -FNAT(imod);
         CENTREY(12*imod-12+2, subd)  = 2*FNAT(imod);

         CENTREX(12*imod-12+3, subd)  =  -FNAT(imod);
         CENTREY(12*imod-12+3, subd)  =   FNAT(imod);

         CENTREX(12*imod-12+4, subd)  =  -FNAT(imod);
         CENTREY(12*imod-12+4, subd)  =   0;

         CENTREX(12*imod-12+5, subd)  =  -FNAT(imod);
         CENTREY(12*imod-12+5, subd)  =  -FNAT(imod);

         CENTREX(12*imod-12+6, subd)  = 0;           
         CENTREY(12*imod-12+6, subd)  =   FNAT(imod);

         CENTREX(12*imod-12+7, subd)  = 0;           
         CENTREY(12*imod-12+7, subd)  =  -FNAT(imod);

         CENTREX(12*imod-12+8, subd)  =   FNAT(imod);
         CENTREY(12*imod-12+8, subd)  =   FNAT(imod);

         CENTREX(12*imod-12+9, subd)  =   FNAT(imod);
         CENTREY(12*imod-12+9, subd)  =   0;

         CENTREX(12*imod-12+10, subd) =   FNAT(imod);
         CENTREY(12*imod-12+10, subd) = -FNAT(imod);

         CENTREX(12*imod-12+11, subd) =   FNAT(imod);
         CENTREY(12*imod-12+11, subd) =-2*FNAT(imod);

         CENTREX(12*imod-12+12, subd) = 2*FNAT(imod);
         CENTREY(12*imod-12+12, subd) =  -FNAT(imod);
      end
   end
   
   
   for NbBCL = 1 : size(DVAL, 2)

      SUBDIV = ...
         SubDivision22(FNAT,DVAL(:,NbBCL),p(:,NbBCL),RAY(:,NbBCL),CENTREX(:,NbBCL),CENTREY(:,NbBCL),pR(:,NbBCL),X,Y,SURF,NpSURF,SizeELM);
      NDIV = 0;
      for i=1:length(SUBDIV)
         if (SUBDIV(i)~=0), NDIV = NDIV + 1; end
      end

      fprintf('\nMaillage en cours ... en sortie :  %d  Zones.', size(SURF,1)+sum(SUBDIV.^2)-NDIV);
      % keyboard
      [X, Y, SURF, NpSURF, SizeELM] = RafineMaillage2(X, Y, SURF, NpSURF, SizeELM, SUBDIV);
      % figure(1);clf;DessinMaillage(X, Y, NpSURF, SURF)

      fprintf('\nStep  %d:  %d  Zones.', NbBCL, size(SURF,1));
   end
   
   

   %% refine for loading
   doRefine = 1;
   
   bnd_soll = 3*FSOLL;

   fsoll_1 = 3*FSOLL;
   rSOLL_1 = FSOLL/15;  % use this from fsoll = 0 to fsoll = fsoll_1
   
   fsoll_2 = 8*FSOLL;
   rSOLL_2 = FSOLL/8;
   
   fsoll_3 = max(X);
   rSOLL_3 = FSOLL/3;
   
   checkZone = @(x,y,bnd_soll,fsoll_i) ...
      any((abs(x)<bnd_soll) & (abs(y)<fsoll_i))  || ...
      any((abs(y)<bnd_soll) & (abs(x)<fsoll_i))  || ...
      any((abs(x+y)<bnd_soll) & (abs(x)<1.41*fsoll_i));
   

   while doRefine
       
      SUBDIV = ones(length(SURF), 1);

      for t = 1 : length(SURF)

         x = X(SURF(t,:));
         y = Y(SURF(t,:));
         if     (checkZone(x,y,bnd_soll,fsoll_1)), SUBDIV(t) = ceil(SizeELM(t)/rSOLL_1);
         elseif (checkZone(x,y,bnd_soll,fsoll_2)), SUBDIV(t) = ceil(SizeELM(t)/rSOLL_2);
         elseif (checkZone(x,y,bnd_soll,fsoll_3)), SUBDIV(t) = ceil(SizeELM(t)/rSOLL_3);
         end
      end
      % SUBDIV(find(SUBDIV>2))=2;
      SUBDIV(SUBDIV > 2) = 2;

      [X, Y, SURF, NpSURF, SizeELM] = RafineMaillage2(X, Y, SURF, NpSURF, SizeELM, SUBDIV);
      
      if (max(SUBDIV)==1), doRefine = 0; end

      %figure(5), clf, plot(X,Y,'.')
      fprintf('\nMaillage en cours ... :  %d  Zones.', size(SURF,1));
   end

   fprintf('\nDone.');
   %%
end % FrequencesBispectreMDDL3()