function [K,M,C,Ke,Me,ELEMDOF,rot] = Assemblage(NNode,NElem,XNOD,YNOD,ELEMGEO,ELEMMAT,ELEMLEN,ELEMNOA,ELEMNOB,ELEMTYP,...
    GEOMSEC,GEOMINE,MATEYOU,MATEMAS)
%
% Boucle sur les lments de la structure et assemble les matrices de
% raideur et de masse lmentaire
% 
% SEE ALSO : RaideurBeam3, MasseBeam3 pour les expressions des matrices
% lm

NDOF =3*NNode; % 3 DDL par noeud
K=zeros(NDOF,NDOF); % Matrice de raideur structurelle
M=zeros(NDOF,NDOF); % Matrice de masse structurelle
C=zeros(NDOF,NDOF); % Matrice d'amortissement structurelle
Ke=zeros(6,6,NElem);
Me=zeros(6,6,NElem);

for el=1:NElem
    
    if ELEMTYP(el) == 1  % Element de poutre  2 noeuds
        
        Igeo = ELEMGEO(el); Imat = ELEMMAT(el);
        A = GEOMSEC(Igeo); I = GEOMINE(Igeo); E = MATEYOU(Imat);
        L = ELEMLEN(el); massevol = MATEMAS(Imat);
        Kel=RaideurBeam3(E*A,E*I,L);       % Matrice de raideur lmentaire
        Mel=MasseBeam3(massevol*A,L);  % Matrice de masse lmentaire
        
        % Rotation
        SinA = (YNOD(ELEMNOB(el))-YNOD(ELEMNOA(el))) / L; 
        CosA = (XNOD(ELEMNOB(el))-XNOD(ELEMNOA(el))) / L;
        ROT = [CosA -SinA 0; SinA CosA 0; 0 0 1];
        ROT = [ROT zeros(3,3);zeros(3,3) ROT];
        Kel = ROT * Kel * ROT';
        Mel = ROT * Mel * ROT';
        
        % Assemblage
        NDOF1 = 3*ELEMNOA(el) - 2;
        NDOF2 = 3*ELEMNOB(el) - 2;
        ELEMDOF(:,el) = [NDOF1:NDOF1+2 NDOF2:NDOF2+2];
        K(NDOF1:NDOF1+2,NDOF1:NDOF1+2) = K(NDOF1:NDOF1+2,NDOF1:NDOF1+2) + Kel(1:3,1:3);
        K(NDOF2:NDOF2+2,NDOF2:NDOF2+2) = K(NDOF2:NDOF2+2,NDOF2:NDOF2+2) + Kel(4:6,4:6);
        K(NDOF1:NDOF1+2,NDOF2:NDOF2+2) = K(NDOF1:NDOF1+2,NDOF2:NDOF2+2) + Kel(1:3,4:6);
        K(NDOF2:NDOF2+2,NDOF1:NDOF1+2) = K(NDOF2:NDOF2+2,NDOF1:NDOF1+2) + Kel(4:6,1:3);
        M(NDOF1:NDOF1+2,NDOF1:NDOF1+2) = M(NDOF1:NDOF1+2,NDOF1:NDOF1+2) + Mel(1:3,1:3);
        M(NDOF2:NDOF2+2,NDOF2:NDOF2+2) = M(NDOF2:NDOF2+2,NDOF2:NDOF2+2) + Mel(4:6,4:6);
        M(NDOF1:NDOF1+2,NDOF2:NDOF2+2) = M(NDOF1:NDOF1+2,NDOF2:NDOF2+2) + Mel(1:3,4:6);
        M(NDOF2:NDOF2+2,NDOF1:NDOF1+2) = M(NDOF2:NDOF2+2,NDOF1:NDOF1+2) + Mel(4:6,1:3);
        
        Ke(:,:,el)=Kel;
        Me(:,:,el)=Mel;
        rot(:,:,el)=ROT;
        
    elseif ELEMTYP(el) == 2   % Ressort fix  une extrmit

        Igeo = ELEMGEO(el); Imat = ELEMMAT(el);
        DDL = GEOMSEC(Igeo); RAID = MATEYOU(Imat);
        NDOF1 = 3*ELEMNOA(el) - 3 + DDL;
        K(NDOF1,NDOF1) = K(NDOF1,NDOF1) + RAID;
        
        Ke(:,:,el)=Kel;
        Me(:,:,el)=Mel;
    elseif ELEMTYP(el) == 3   % Dash-pot
        
        Imat = ELEMMAT(el); Visco = MATEYOU(Imat); Raide = MATEMAS(Imat);
        L = ELEMLEN(el);
        
        Cel = zeros(6,6);
        Cel(1,1) =  Visco  ; Cel(1,4) = -Visco;
        Cel(4,1) = -Visco  ; Cel(4,4) =  Visco;
        Kel = zeros(6,6);
        Kel(1,1) =  Raide  ; Kel(1,4) = -Raide;
        Kel(4,1) = -Raide  ; Kel(4,4) =  Raide;
        
        % Rotation
        SinA = (YNOD(ELEMNOB(el))-YNOD(ELEMNOA(el))) / L; 
        CosA = (XNOD(ELEMNOB(el))-XNOD(ELEMNOA(el))) / L;
        ROT = [CosA -SinA 0; SinA CosA 0; 0 0 1];
        ROT = [ROT zeros(3,3);zeros(3,3) ROT];
        Cel = ROT * Cel * ROT';
        Kel = ROT * Kel * ROT';        

        % Assemblage
        NDOF1 = 3*ELEMNOA(el) - 2;
        NDOF2 = 3*ELEMNOB(el) - 2;
        C(NDOF1:NDOF1+2,NDOF1:NDOF1+2) = C(NDOF1:NDOF1+2,NDOF1:NDOF1+2) + Cel(1:3,1:3);
        C(NDOF2:NDOF2+2,NDOF2:NDOF2+2) = C(NDOF2:NDOF2+2,NDOF2:NDOF2+2) + Cel(4:6,4:6);
        C(NDOF1:NDOF1+2,NDOF2:NDOF2+2) = C(NDOF1:NDOF1+2,NDOF2:NDOF2+2) + Cel(1:3,4:6);
        C(NDOF2:NDOF2+2,NDOF1:NDOF1+2) = C(NDOF2:NDOF2+2,NDOF1:NDOF1+2) + Cel(4:6,1:3);
        K(NDOF1:NDOF1+2,NDOF1:NDOF1+2) = K(NDOF1:NDOF1+2,NDOF1:NDOF1+2) + Kel(1:3,1:3);
        K(NDOF2:NDOF2+2,NDOF2:NDOF2+2) = K(NDOF2:NDOF2+2,NDOF2:NDOF2+2) + Kel(4:6,4:6);
        K(NDOF1:NDOF1+2,NDOF2:NDOF2+2) = K(NDOF1:NDOF1+2,NDOF2:NDOF2+2) + Kel(1:3,4:6);
        K(NDOF2:NDOF2+2,NDOF1:NDOF1+2) = K(NDOF2:NDOF2+2,NDOF1:NDOF1+2) + Kel(4:6,1:3);
     
        Ke(:,:,el)=Kel;
        Me(:,:,el)=Mel;
    elseif ELEMTYP(el) == 4   % Barre de treillis
        el
        Igeo = ELEMGEO(el); Imat = ELEMMAT(el);
        A = GEOMSEC(Igeo); E = MATEYOU(Imat);
        L = ELEMLEN(el); massevol = MATEMAS(Imat);
        Raide = E*A/L;

        Kel = zeros(6,6);
        Kel(1,1) =  Raide  ; Kel(1,4) = -Raide;
        Kel(4,1) = -Raide  ; Kel(4,4) =  Raide;
        Mel = zeros(6,6);
        Mel(1,1) =  massevol*A*L/2  ; Mel(4,4) =  massevol*A*L/2;
                
        % Rotation
        SinA = (YNOD(ELEMNOB(el))-YNOD(ELEMNOA(el))) / L; 
        CosA = (XNOD(ELEMNOB(el))-XNOD(ELEMNOA(el))) / L;
        ROT = [CosA -SinA 0; SinA CosA 0; 0 0 1];
        ROT = [ROT zeros(3,3);zeros(3,3) ROT];
        Mel = ROT * Mel * ROT';
        Kel = ROT * Kel * ROT';        

        % Assemblage
        NDOF1 = 3*ELEMNOA(el) - 2;
        NDOF2 = 3*ELEMNOB(el) - 2;
        M(NDOF1:NDOF1+2,NDOF1:NDOF1+2) = M(NDOF1:NDOF1+2,NDOF1:NDOF1+2) + Mel(1:3,1:3);
        M(NDOF2:NDOF2+2,NDOF2:NDOF2+2) = M(NDOF2:NDOF2+2,NDOF2:NDOF2+2) + Mel(4:6,4:6);
        M(NDOF1:NDOF1+2,NDOF2:NDOF2+2) = M(NDOF1:NDOF1+2,NDOF2:NDOF2+2) + Mel(1:3,4:6);
        M(NDOF2:NDOF2+2,NDOF1:NDOF1+2) = M(NDOF2:NDOF2+2,NDOF1:NDOF1+2) + Mel(4:6,1:3);
        K(NDOF1:NDOF1+2,NDOF1:NDOF1+2) = K(NDOF1:NDOF1+2,NDOF1:NDOF1+2) + Kel(1:3,1:3);
        K(NDOF2:NDOF2+2,NDOF2:NDOF2+2) = K(NDOF2:NDOF2+2,NDOF2:NDOF2+2) + Kel(4:6,4:6);
        K(NDOF1:NDOF1+2,NDOF2:NDOF2+2) = K(NDOF1:NDOF1+2,NDOF2:NDOF2+2) + Kel(1:3,4:6);
        K(NDOF2:NDOF2+2,NDOF1:NDOF1+2) = K(NDOF2:NDOF2+2,NDOF1:NDOF1+2) + Kel(4:6,1:3);

        Ke(:,:,el)=Kel;
        Me(:,:,el)=Mel;
    elseif ELEMTYP(el) == 5   % Barre de treillis non linaire (pour cable p.ex)
        
        Igeo = ELEMGEO(el); Imat = ELEMMAT(el);
        A = GEOMSEC(Igeo); E = MATEYOU(Imat);
        L = ELEMLEN(el); massevol = MATEMAS(Imat);
        Mel = massevol*A*L/2 * diag([1 1 0 1 1 0]);
                
        % Rotation
        SinA = (YNOD(ELEMNOB(el))-YNOD(ELEMNOA(el))) / L; 
        CosA = (XNOD(ELEMNOB(el))-XNOD(ELEMNOA(el))) / L;
        ROT = [CosA -SinA 0; SinA CosA 0; 0 0 1];
        ROT = [ROT zeros(3,3);zeros(3,3) ROT];
        Mel = ROT * Mel * ROT';

        % Assemblage
        NDOF1 = 3*ELEMNOA(el) - 2;
        NDOF2 = 3*ELEMNOB(el) - 2;
        M(NDOF1:NDOF1+2,NDOF1:NDOF1+2) = M(NDOF1:NDOF1+2,NDOF1:NDOF1+2) + Mel(1:3,1:3);
        M(NDOF2:NDOF2+2,NDOF2:NDOF2+2) = M(NDOF2:NDOF2+2,NDOF2:NDOF2+2) + Mel(4:6,4:6);
        M(NDOF1:NDOF1+2,NDOF2:NDOF2+2) = M(NDOF1:NDOF1+2,NDOF2:NDOF2+2) + Mel(1:3,4:6);
        M(NDOF2:NDOF2+2,NDOF1:NDOF1+2) = M(NDOF2:NDOF2+2,NDOF1:NDOF1+2) + Mel(4:6,1:3);

        Ke(:,:,el)=Kel;
        Me(:,:,el)=Mel;
    end    
end