## Heatwave identification, classification, and visualization: A python-based code 


M.Y. Joshi<sup>1</sup>, D. Amaripadath<sup>2</sup>, A. Machard<sup>3,4</sup>, and S. Attia<sup>1</sup>

<sup>1</sup>Local Environment Management and Analysis (LEMA), Urban and Environmental Engineering Department, University of Liège, 4000 Liège, Belgium.  
<sup>2</sup>Sustainable Building Design Lab, Department of UEE, Faculty of Applied Sciences, University of Liege, 4000 Liege, Belgium          
<sup>3</sup>Centre Scientifique et Technique du Batiment (CSTB), Département Energie et Environnement, 24 Rue Joseph Fourier, 38400 Saint-Martin-d'Hères, France                          
<sup>4</sup>La Rochelle Université, Laboratoire des Sciences de l'Ingénieur pour l'Environnement (LASIE, UMR CNRMS 7356), 23 Avenue Albert Einstein, 17000 La Rochelle, France

This code can detect, classify, and visualize heatwaves considering the thresholds based on percentiles of daily mean temperature distribution over past years (Ouzeau et al., 2016). Here, we develop the code by Machard et al. (2022) further by introducing stripes visualising the average annual summer temperature. We also add a possibility for comparing heatwaves for two or more cities. Additionally, with this code, you can visualise and compare the intense heatwaves for the cities in a country/region on a map. The code is easy to use for beginners and professionals working with heatwaves. The code can directly produce graphs and information indicating the heatwaves and comparing it for two or more cities. 


To use this code please cite the following codes:
1. our code citation. 
2. Machard, A.(2022). Assembling-future-weather-files-including-heatwaves: v1.0.0. Zenodo, doi: 10.5281/zenodo.7300024.
3. Machard, A. , Inard, C., Alessandrini, J.M., Pelé, C., Ribéron, J. A Methodology for Assembling Future Weather Files Including Heatwaves for Building Thermal Simulations from the European Coordinated Regional Downscaling Experiment (EURO-CORDEX) Climate Data https://doi.org/10.3390/en13133424


**References**

Ouzeau, G., et al. (2016). Heat waves analysis over France in present and future climate: Application of a new method on the EURO-CORDEX ensemble. Climate Services, 4, 1-12. 34 20.      
Machard, A.(2022). Assembling-future-weather-files-including-heatwaves: v1.0.0. Zenodo, doi: 10.5281/zenodo.7300024.
