%
% Damping of a free-free beam with RL shunts and an electrical network
%
% (c) G. Raze, J. Dietrich, B. Lossouarn and G. Kerschen
% Mar 2022

%% Load model

load('FreeFreeBeamModel');
N = length(beamss.A)/2;

Omoc2 = -beamss.A((N+1):end,1:N);
Omoc = diag(sqrt(diag(Omoc2(4:end,4:end))));
B = beamss.B((N+4):end,2:end);
C = beamss.C(2:end,4:N);
D = -beamss.D(2:end,2:end);


%% Case 1: RL shunts

for ii = 1 : 4
  
  modes = cell(20,1);
  patches = cell(20,1);
  w = cell(20,1);
  for nn = 1 : 20
    modes{nn} = ii;
    patches{nn} = nn;
    w{nn} = 1;
  end
  
  % Compute shunts sate-space matrices
  [An,Bn,Cn,Kcn] = makeDecentralizedNetwork(Omoc,B,C,D,modes,patches,w,true);
  
  % Connect the beam to the shunts
  switch ii
    case 1
      sysShunt1 = feedback(beamss,-ss(An,Bn,Cn,zeros(20)),2:21,2:21);
    case 2
      sysShunt2 = feedback(beamss,-ss(An,Bn,Cn,zeros(20)),2:21,2:21);
    case 3
      sysShunt3 = feedback(beamss,-ss(An,Bn,Cn,zeros(20)),2:21,2:21);
    case 4
      sysShunt4 = feedback(beamss,-ss(An,Bn,Cn,zeros(20)),2:21,2:21);
  end
    
end


%% Case 2: Fully centralized network

modes = {1:1:4};
patches = {1:20};
w = {ones(4,1)};

% Compute network sate-space matrices
[An,Bn,Cn,Kcn] = makeDecentralizedNetwork(Omoc,B,C,D,modes,patches,w,true);

% Connect the beam to the network
sysNetwork = feedback(beamss,-ss(An,Bn,Cn,zeros(20)),2:21,2:21);


%% Compare results
omegav = 2*pi*linspace(80,1200,1e4);
omegav = omegav(:);

figure('Units','normalized','Position',[0.1,0.25,0.8,0.5])
hold on
plot(omegav/2/pi,db(omegav.*squeeze(freqresp(beamss(1,1),omegav))),'-k')
plot(omegav/2/pi,db(omegav.*squeeze(freqresp(sysShunt1(1,1),omegav))),'linewidth',2)
plot(omegav/2/pi,db(omegav.*squeeze(freqresp(sysShunt2(1,1),omegav))),'linewidth',2)
plot(omegav/2/pi,db(omegav.*squeeze(freqresp(sysShunt3(1,1),omegav))),'linewidth',2)
plot(omegav/2/pi,db(omegav.*squeeze(freqresp(sysShunt4(1,1),omegav))),'linewidth',2)
plot(omegav/2/pi,db(omegav.*squeeze(freqresp(sysNetwork(1,1),omegav))),'-.','linewidth',1)
set(gca,'xscale','log')
xlabel('Frequency (Hz)')
ylabel('Mobility (dB, ref. m/s/N)')
set(gca,'fontsize',14)
box on
xlim([omegav(1),omegav(end)]/2/pi)
ylim([-60,-15])
