%
% Plot the experimental FRFs of a clamped-free piezoelectric beam with a
% thin lamina controlled by shunts or newtorks.
%
% Results for a control over four modes.
%
% (c) G. Raze, J. Dietrich, B. Lossouarn and G. Kerschen
% Mar 2022

expFolder = '.\Data\5p\';       % Data folder


FRFFactor = 1/4.44822;          % Factor for the FRF (there was an error in the sensitivity of a sensor)


% Open circuit
[froc,hoc] = TestLabFRFData('C:\Users\Ghislain\Documents\PhD\Experiments\2021_10_Networks\Control\OC2');
hoc = abs(hoc./(2*pi*froc).^2)*FRFFactor;

% Newtork
[frn,hn] = TestLabFRFData([expFolder,'Network_4modes']);
hnx = abs(hn./(2*pi*frn).^2)*FRFFactor;

% Shunts
[frs,hs] = TestLabFRFData([expFolder,'Shunt_4modes']);
hns = abs(hs./(2*pi*frs).^2)*FRFFactor;

% Decentralized
[frd,hd] = TestLabFRFData([expFolder,'Decentralized_4modes']);
hnd = abs(hd./(2*pi*frd).^2)*FRFFactor;


%% FRF plot

col = get(groot,'defaultAxesColorOrder');

figure('Units','normalized','Position',[0.1,0.25,0.8,0.5])
hold on
plot(froc,db(hoc),'-k','linewidth',1)
plot(frs,db(hns),'-','color',col(1,:),'linewidth',1)
plot(frd,db(hnd),'-','color',col(3,:),'linewidth',1)
plot(frn,db(hnx),'-','color',col(2,:),'linewidth',1)
xlim([20,1000])
ylim([-160,-60])
set(gca,'xscale','log')
box on
xlabel('Frequency (Hz)')
ylabel('Receptance (dB, ref. m/N)')
set(gca,'fontsize',14)
set(gca,'XTick',[20,50,100,200,500,1000])