%
% Plot the experimental FRFs of a clamped-free piezoelectric beam with a
% thin lamina controlled by shunts or newtorks.
%
% Results for a control over three modes.
%
% (c) G. Raze, J. Dietrich, B. Lossouarn and G. Kerschen
% Mar 2022

expFolder = '.\Data\2p\3Modes\';        % Data folder

FRFFactor = 1/4.44822;                  % Factor for the FRF (there was an error in the sensitivity of a sensor)
dbFactor = db(4.44822);


% Open circuit
[froc,hoc] = TestLabFRFData('.\Data\OC2');
hoc = abs(hoc./(2*pi*froc).^2)*FRFFactor;



fRange = [20,50 ; 100, 200 ; 300, 500];     % Frequency range for the peak values
pOC = zeros(1,3);                           % Peak amplitudes (OC)
pShunt = zeros(4,3);                        % Peak amplitudes (shunts)
pNetwork = zeros(4,3);                      % Peak amplitudes (network)

% Open circuit peaks
for jj = 1 : 3
  pOC(1,jj) = max(db(hoc(and(froc>fRange(jj,1),froc<fRange(jj,2)))));
end


%% FRFs - Networks

cases = {'Baseline','Mode1','Mode2','Mode3'};
col = get(groot,'defaultAxesColorOrder');
col = [col(5,:) ; col];

figure('Units','normalized','Position',[0.1,0.25,0.8,0.5])
hold on
plot(froc,db(hoc),'-k','linewidth',1)
for ii = 1 : length(cases)
  [fr,h] = TestLabFRFData([expFolder,'Network_',cases{ii}]);
  hx = abs(h./(2*pi*fr).^2)*FRFFactor;
  if ii == 1
    lw = 2;
  else
    lw = 1;
  end
  plot(fr,db(hx),'-','color',col(ii,:),'linewidth',lw)
  
  for jj = 1 : 3
    pShunt(ii,jj) = max(db(hx(and(fr>fRange(jj,1),fr<fRange(jj,2)))));
  end
end
xlim([20,500])
set(gca,'xscale','log')
box on
xlabel('Frequency (Hz)')
ylabel('Receptance (dB, ref. m/N)')
set(gca,'fontsize',14)
set(gca,'XTick',[20,50,100,200,500])


%% FRFs - shunts

figure('Units','normalized','Position',[0.1,0.25,0.8,0.5])
hold on
plot(froc,db(hoc),'-k','linewidth',1)
for ii = 1 : length(cases)
  [fr,h] = TestLabFRFData([expFolder,'Shunts_',cases{ii}]);
  hx = abs(h./(2*pi*fr).^2)*FRFFactor;
  if ii == 1
    lw = 2;
  else
    lw = 1;
  end
  
  plot(fr,db(hx),'-','color',col(ii,:),'linewidth',lw)
  
  for jj = 1 : 3
    pNetwork(ii,jj) = max(db(hx(and(fr>fRange(jj,1),fr<fRange(jj,2)))));
  end
end
xlim([20,500])
set(gca,'xscale','log')
box on
xlabel('Frequency (Hz)')
ylabel('Receptance (dB, ref. m/N)')
set(gca,'fontsize',14)
set(gca,'XTick',[20,50,100,200,500])
