%
% Plot the experimental FRFs of a clamped-free piezoelectric beam with a
% thin lamina controlled by shunts or newtorks.
%
% Results for a control over two modes.
%
% (c) G. Raze, J. Dietrich, B. Lossouarn and G. Kerschen
% Mar 2022

expFolder = '.\Data\2p\Performance\';   % Data folder

FRFFactor = 1/4.44822;                  % Factor for the FRF (there was an error in the sensitivity of a sensor)

% Open-circuit
[froc,hoc] = TestLabFRFData('.\Data\OC2');
hoc = abs(hoc./((2*1i*pi*froc).^2))*FRFFactor;

% Cases (w1/w2 without correction, see readme.txt)
cases = {'1e-3','3-2e-3','1e-2','3-2e-2','1e-1','1-6e-1','2-5e-1','4e-1',...
  '6-3e-1','1e0','1-6e0','2-5e0','4e0','6-3e0','1e1','3-2e1','1e2',...
  '3-2e2','1e3'};


ii = 7;         % Selected case for FRF illustration

% Network
[frn,hn] = TestLabFRFData([expFolder,'Network_w',cases{ii}]);
hxn = abs(hn./(2*pi*frn).^2)*FRFFactor;
  
% Shunts
[frd,hd] = TestLabFRFData([expFolder,'Shunts_w',cases{ii}]);
hxd = abs(hd./(2*pi*frd).^2)*FRFFactor;

%% FRF plot

figure('Units','normalized','Position',[0.1,0.25,0.8,0.5])
hold on
plot(froc,db(hoc),'-k','linewidth',1)
plot(frd,db(hxd),'-','linewidth',1)
plot(frn,db(hxn),'-','linewidth',1)
xlim([20,200])
set(gca,'xscale','log')
box on
xlabel('Frequency (Hz)')
ylabel('Receptance (dB, ref. m/N)')
set(gca,'fontsize',14)
set(gca,'XTick',[20,50,100,200])