%
% Half power method to estimate the damping ratio
% 
% Input:
%   * h: FRF around a peak
%   * w: associated frequency vector
%
% Output:
%   * xi: estimated damping ratio
%
% (c) G. Raze, J. Dietrich, B. Lossouarn and G. Kerschen
% Mar 2022

function xi = halfPowerDamping(h,w)

  % Peak
  [hMax,ind] = max(abs(h));
  w0 = w(ind);
  
  % Left part of the peak
  hl = abs(h(1:ind));
  wl = w(1:ind);
  indL = find(hl(2:end)<=hl(1:end-1),1,'last');
  if isempty(indL)
    indL = 1;
  end
  wl = wl(indL:end);
  hl = hl(indL:end);

  % Right part of the peak
  hr = abs(h(ind+1:end));
  wr = w(ind+1:end);
  indR = find(hr(1:end-1)<=hr(2:end),1);
  if isempty(indR)
    indR = length(hr);
  end
  wr = wr(1:indR);
  hr = hr(1:indR);

  % -3dB frequencies 
  w1 = interp1(db(hl),wl,db(hMax)-3);
  w2 = interp1(db(hr),wr,db(hMax)-3);
  
  % Modal damping
  xi = double((w2-w1)/(2*w0));
end