%
% Prediction of the attenuation brought by a series RL shunt
%
% See
%
% Thomas, O., Ducarne, J., Deu, J.-F. (2012) 
% Performance of piezoelectric shunts for vibration reduction,
% Smart Materials and Structures, 21(1), p 015008. doi: 10.1088/0964-1726/21/1/015008.
%
% Sep 2021
%
% Input:
%   * k: modal electromechanical coupling factor (-)
%   * xi: modal damping ratio (-)
%
% Output:
%   * Adb: predicted attenuation (dB)
%
function Adb = ThomasReduction(k,xi)

  n = 8 * (9*k.^4 + 17*k.^2 + 8 - k*sqrt(2).*sqrt(1+k.^2).*(6*k.^2+7)) * xi^2 + ...
    16 * sqrt(3) * k.*(1+k.^2).*(sqrt(2)*(1+k.^2) - k)*xi - ...
    3 * k.^3 *sqrt(2) .* (1+k.^2).^1.5 + 6*k.^6 + 14*k.^4 + 8*k.^2;
  
  f = n./( 8 * (6*k.^2 + 8 - 3*k*sqrt(2).*sqrt(1+k.^2)) * xi^2*(1-xi^2));
  
  Adb = 10*log10(f);

end