%
% Single-degree-of-freedom piezoelectric damping with parallel RL shunt
% (c) G. Raze, J. Dietrich, B. Lossouarn and G. Kerschen
% Nov 2020
%

% System characteristics
m = 1;
ksc = 1;
wsc = sqrt(ksc/m);
Cp = 1;

% EEMCFs
Kcv = [0.01;0.05;0.1];



% FRFs

omV = linspace(0.85*wsc,1.15*wsc,10000);

figure
hold on
plot(omV,db(abs(1./(1-(omV/wsc).^2))),'-k');
for ii = 1 : length(Kcv)
  L = 2/((2-Kcv(ii)^2)*wsc^2*Cp);
  R = sqrt(2/(3*Kcv(ii)^2))/(wsc*Cp);
  h = 1./(1 - (omV/wsc).^2 - Kcv(ii)^2*(omV/wsc).^2./(-(omV/wsc).^2 + 1i*omV/wsc*1/(R*Cp*wsc) + 1/(L*Cp*wsc^2)));  
  plot(omV,db(abs(h)),'-','linewidth',2)
end
box on
set(gca,'fontsize',14)
xlabel('\omega/\omega_{sc} (-)')
ylabel('|k_{sc}x/f| (dB)')
ylim([0,50])
figureMemorySizeReduction(gcf)
saveas(gcf,'C:\Users\Ghislain\Documents\PhD\Papers\First author\2020_11_Networks\Schematics\post\sdofParallelShunt','epsc')