%
% Admittance of an ideal Norton admittance multimodal shunt
%
% Input:
%   * ri: residues
%   * zi: zeros frequencies
%   * zetai: electrical damping ratios
%   * Cpe: piezoelectric capacitance at constant strain
%
% Output:
%   * Yid: shunt admittance
%
% (c) G. Raze, J. Dietrich and G. Kerschen
% Sep 2021
%
function Yid = idealAdmittance(ri,zi,zetai,Cpe)

  if length(ri) > length(zi)
    r0 = ri(1);
    ri = ri(2:end);
  else
    r0 = 0;
  end
  
  % Computation of a pole-zero-gain model
  pol = 0;
  pol0 = 1;
  for ii = 1 : length(ri)
    poli = [1,0,0];
    for jj = 1 : length(ri)
      if ii ~= jj 
        poli = conv(poli,[1 , 2*zetai(jj)*zi(jj) , zi(jj)^2]);
      end
    end
    pol = pol + ri(ii)*poli;
    
    pol0 = conv(pol0,[1 , 2*zetai(ii)*zi(ii) , zi(ii)^2]);
  end

  num = (1-r0)*pol0 - pol;
  while num(1) == 0
    num = num(2:end);
  end
  den = r0*pol0 + pol;
  while den(1) == 0
    den = den(2:end);
  end
  
  zz = [roots(num);0];
  pp = roots(den);
  kk = num(1)/den(1)*Cpe;
  
  Yid = zpk(zz,pp,kk);
end