% Compute the admittance of Hollkamp's shunt from its electrical
% parameters.
%
% (c) G. Raze, J. Dietrich and G. Kerschen
% Mar 2022
%
% Input:
%   * L: inductance vector of length Ns
%   * R: resistance vector of length Ns
%   * C: capacitance vector of length Ns (the first element is discarded
% 
% Output:
%   * Y: Hollkamp's shunt admittance
%
function Y = HollkampAdmittance(L,R,C)
  s = zpk(0,[],1);
  
  Y = 1/(s*L(1) + R(1));
  for nn = 2 : length(L)
    Y = Y + s/L(nn)/(s^2 + R(nn)/L(nn)*s + 1/(C(nn)*L(nn)));
  end
end