%
% Plot of the experimental results obtained with multi-resonant
% piezoelectric shunts controlling a clamped-free piezoelectric beam.
%
%
% (c) G. Raze, J. Dietrich and G. Kerschen
% Mar 2022

%% Experimental data

addpath('.\Experimental');

xl = [20,500];        % X axis limits (Hz)
yl = [-150,-70];      % Y axis limits (dB)
xtck = [50,100,500];  % X axis ticks (Hz)


% Open-circuit FRF
[froc,hoc] = TestLabFRFData('Experimental/Results/OC');

% Hollkamp's shunt
[frH1,hH1] = TestLabFRFData('Experimental/Results/Hollkamp_Mode1');   % Emphasis on mode 1
[frH2,hH2] = TestLabFRFData('Experimental/Results/Hollkamp_Mode2');   % Emphasis on mode 2
[frH3,hH3] = TestLabFRFData('Experimental/Results/Hollkamp_Mode3');   % Emphasis on mode 3

% Second Foster Canonical Form shunt
[frSF1,hSF1] = TestLabFRFData('Experimental/Results/SFCF_Mode1');   % Emphasis on mode 1
[frSF2,hSF2] = TestLabFRFData('Experimental/Results/SFCF_Mode2');   % Emphasis on mode 2
[frSF3,hSF3] = TestLabFRFData('Experimental/Results/SFCF_Mode3');   % Emphasis on mode 3

% Current Flowing shunt
[frCF1,hCF1] = TestLabFRFData('Experimental/Results/CF_R0-1');   % Emphasis on mode 1
[frCF2,hCF2] = TestLabFRFData('Experimental/Results/CF_R0-5');   % Emphasis on mode 2
[frCF3,hCF3] = TestLabFRFData('Experimental/Results/CF_R0-7');   % Emphasis on mode 3

% Series-Parallel Impedance Structure
[frSP1,hSP1] = TestLabFRFData('Experimental/Results/SPIS_R0-1');   % Emphasis on mode 1
[frSP2,hSP2] = TestLabFRFData('Experimental/Results/SPIS_R0-5');   % Emphasis on mode 2
[frSP3,hSP3] = TestLabFRFData('Experimental/Results/SPIS_R0-7');   % Emphasis on mode 3


%% Plots

% Hollkamp's shunt - FRFs
figure
hold on
plot(froc,db(hoc./((2*pi*1i*froc).^2)),'-k')
plot(frH1,db(hH1./((2*pi*1i*frH1).^2)),'linewidth',1)
plot(frH2,db(hH2./((2*pi*1i*frH2).^2)),'linewidth',1)
plot(frH3,db(hH3./((2*pi*1i*frH3).^2)),'linewidth',1)
set(gca,'xscale','log')
box on
set(gca,'fontsize',14)
xlabel('Frequency (Hz)')
ylabel('Magnitude (dB, ref. m/N)')
xlim(xl)
ylim(yl)
set(gca,'XTick',xtck)


% SFCF shunt - FRFs
figure
hold on
plot(froc,db(hoc./((2*pi*1i*froc).^2)),'-k')
plot(frSF1,db(hSF1./((2*pi*1i*frSF1).^2)),'linewidth',1)
plot(frSF2,db(hSF2./((2*pi*1i*frSF2).^2)),'linewidth',1)
plot(frSF3,db(hSF3./((2*pi*1i*frSF3).^2)),'linewidth',1)
set(gca,'xscale','log')
box on
set(gca,'fontsize',14)
xlabel('Frequency (Hz)')
ylabel('Magnitude (dB, ref. m/N)')
xlim(xl)
ylim(yl)
set(gca,'XTick',xtck)


% CF shunts - FRFs
figure
hold on
plot(froc,db(hoc./((2*pi*1i*froc).^2)),'-k')
plot(frCF1,db(hCF1./((2*pi*1i*frCF1).^2)),'linewidth',1)
plot(frCF2,db(hCF2./((2*pi*1i*frCF2).^2)),'linewidth',1)
plot(frCF3,db(hCF3./((2*pi*1i*frCF3).^2)),'linewidth',1)
set(gca,'xscale','log')
box on
set(gca,'fontsize',14)
xlabel('Frequency (Hz)')
ylabel('Magnitude (dB, ref. m/N)')
xlim(xl)
ylim(yl)
set(gca,'XTick',xtck)


% SPIS - FRFs
figure
hold on
plot(froc,db(hoc./((2*pi*1i*froc).^2)),'-k')
plot(frSP1,db(hSP1./((2*pi*1i*frSP1).^2)),'linewidth',1)
plot(frSP2,db(hSP2./((2*pi*1i*frSP2).^2)),'linewidth',1)
plot(frSP3,db(hSP3./((2*pi*1i*frSP3).^2)),'linewidth',1)
set(gca,'xscale','log')
box on
set(gca,'fontsize',14)
xlabel('Frequency (Hz)')
ylabel('Magnitude (dB, ref. m/N)')
xlim(xl)
ylim(yl)
set(gca,'XTick',xtck)