%
% Investigation of the effect of the resistances of Hollkamp's shunt on the
% performance in terms of vibration reduction of a clamped-free
% piezoelectric beam.
%
%
% (c) G. Raze, J. Dietrich and G. Kerschen
% Mar 2022


addpath('IdealCircuitsCodes\')
addpath('CircuitsTuning\')

%% Beam model

load('BeamModel');                    % Beam with open-circuited patch
load('HollkampParameters')            % Hollkamp's circuit parameters with negative resistance



% Laplace variable
s = zpk(0,[],1);

% Plots
xl = [10;250];                        % X axis limits (Hz)
yl = [-150,-70];                      % Y axis limits (dB)
w = linspace(10*2*pi,2*pi*250,1e4);   % Frequency vector (rad/s)

% Resistance
Rv = [1e2,1e3,2e3,1e4];

% FRFs
m = bode(beamss(1,1),w);        % Open-circuit


%% Resistance variation

% Branch 1 - FRF
figure
hold on
plot(w/2/pi,db(squeeze(m)),'-k')
for ii = 1 : length(Rv)
  % Resistances
  Rchp = [Rv(ii);0];
  
  % Shunt admittance
  Y = HollkampAdmittance(Lch,Rchp,Cch);

  % Controlled system FRF
  beamssc = feedback(beamss,-Y/s,2,2);
  mc = bode(beamssc(1,1),w);
  plot(w/2/pi,db(squeeze(mc)),'-','linewidth',2)
end
box on
set(gca,'fontsize',14)
set(gca,'xscale','log')
xlabel('Frequency (Hz)')
ylabel('Receptance (dB, ref. m/N)')
xlim(xl)
ylim(yl)
set(gca,'XTick',[5e1,1e2,2e2])

figure
plot(w/2/pi,db(squeeze(m)),'-k')
hold on
for ii = 1 : length(Rv)
  % Resistances
  Rchp = [0;Rv(ii)];
  
  % Shunt admittance
  Y = HollkampAdmittance(Lch,Rchp,Cch);

  % Controlled system FRF
  beamssc = feedback(beamss,-Y/s,2,2);
  mc = bode(beamssc(1,1),w);
  plot(w/2/pi,db(squeeze(mc)),'-','linewidth',2)
end
box on
xlim([20 200])
ylim([-160,-40])
set(gca,'fontsize',14)
set(gca,'xscale','log')
xlabel('Frequency (Hz)')
ylabel('Receptance (dB, ref. m/N)')
xlim(xl)
ylim(yl)
set(gca,'XTick',[5e1,1e2,2e2])