%
% Extract FRF data from a TestLab Matlab file
% 
% Input:
%   * file: TestLab file name
%
% Output:
%   * fr: frequency vector
%   * y: FRF
%
% (c) G. Raze, J. Dietrich and G. Kerschen
% Sep 2021
%
function [fr,y] = TestLabFRFData(file)

  data = load(file);
  fr = data.FRF.x_values.start_value + ...
    (0:1:(data.FRF.x_values.number_of_values-1)).'*data.FRF.x_values.increment;
  y = data.FRF.y_values.values;
end