%
% Admittance of an ideal Thevenin impedance multimodal shunt
%
% Input:
%   * ri: residues
%   * zi: zeros frequencies
%   * zetai: electrical damping ratios
%   * Cpe: piezoelectric capacitance at constant strain
%
% Output:
%   * Yid: shunt admittance
%
% (c) G. Raze, J. Dietrich and G. Kerschen
% Sep 2021
%
function Yid = idealImpedance(ri,zi,zetai,Cpe)

  if length(ri) > length(zi)
    r0 = ri(1);
    ri = ri(2:end);
  else
    r0 = 0;
  end
  
  % Computation of a pole-zero-gain model
  pol = 0;
  pol0 = 1;
  for ii = 1 : length(ri)
    poli = 1;
    for jj = 1 : length(ri)
      if ii ~= jj 
        poli = conv(poli,[1/zi(jj)^2 , 2*zetai(jj)/zi(jj) , 1]);
      end
    end
    pol = pol + ri(ii)*poli;
    
    pol0 = conv(pol0,[1/zi(ii)^2 , 2*zetai(ii)/zi(ii) , 1]);
  end

  num = r0*pol0 + [0,0,pol];
  while num(1) == 0
    num = num(2:end);
  end
  den = (1-r0)*pol0 - [0,0,pol];
  while den(1) == 0
    den = den(2:end);
  end
  
  zz = [roots(num);0];
  pp = roots(den);
  kk = num(1)/den(1)*Cpe;
  
  Yid = zpk(zz,pp,kk);
end