% Modification of a digital shunt admittance to counter delay-induced
% instabilities: approximation for the series RL shunt
%
% (c) G. Raze, J. Dietrich and G. Kerschen
% Apr 2022
% 
% Input:
%   * tau: sampling period
%   * Kc, effective/generalized electromechanical coupling factor
%
% Output:
%   * deltaL: inductance modification factor
%   * deltaR: resistance modification factor
%
function [deltaL,deltaR] = approximateDelaysModificationRLShunt(tau,Kc)

  % Approximate frequency ratio
  dl0 = (sin(tau)./tau-1);
  dl1 = sqrt(6)*(-4+4*cos(tau)+tau.*sin(tau))./(8*tau);
  dl2 = -(-16*tau.*cos(tau)+16*sin(tau)+tau.^2.*sin(tau))./(32*tau);
  
  deltaL = dl0+Kc.*dl1 + Kc.^2.*dl2;
  
  
  % Approximate damping ratio
  r0 = -(4*tau+tau.*cos(tau)-5*sin(tau))./(4*tau);
  rm1 = sqrt(6)*(1-cos(tau))./(3*tau);
  
  deltaR = rm1./Kc+r0;

end