%
% Plot the FRF of a single-degree-of-freedom oscillator controlled by a
% digital vibration absorber for different sample times. The admittance is
% modified to account for the delays.
%
%
% (c) G. Raze, J. Dietrich and G. Kerschen
% Apr 2022

% Electromechanical coupling factor
Kcv = [0.01,0.1];

% Delayed FRF
for nn = 1 : length(Kcv)
  Kc = Kcv(nn);
  
  % Shunt characteristics
  [delta2,zeta,r] = ikegame(Kc);
  delta2 = 1/(delta2^2*(1+Kc^2));
  zeta = zeta/sqrt(1+Kc^2);
  
  % Nominal closed-loop poles
  p011 = [1,0,1+Kc^2];
  p01 = conv(p011,[delta2,zeta,0]);
  p02 = [0,0,1,0,1];
  p0 = p01 + p02;
  pp = roots(p0);
  
  % Laplace variable vector
  sv = 1i*linspace(0.8,1.2,1e4);
  
  % Critical delay
  tauc = criticalDelays(Kc);
  tauc = tauc(3);
  
  % Sample times
  tauv = [1e-2,1e-1,5e-1,1,pi];
  figure
  hold on
  for ii = 1 : length(tauv)
    
    % Modification procedure
    b = 1-(1-exp(-tauv(ii)*pp))./(tauv(ii)*pp);
    A = [-pp*delta2./(pp*delta2+zeta),-zeta./(pp*delta2+zeta)];
    d = real(pinv(A)*b);
    delta2m = (1+d(1))*delta2;
    zetam = (1+d(2))*zeta;
    
    % FRF
    h = 1./abs(1+Kc^2+sv.^2-Kc^2./(1+(zetam*sv+delta2m*sv.^2).*(tauv(ii)*sv)./(1-exp(-tauv(ii)*sv))));
    plot(abs(sv),db(h),'linewidth',2)
  end
  if nn == 2
    xlim([0.8,1.2])
    ylim([0,50])
  else
    xlim([0.97,1.03])
    ylim([0,75])
  end
  box on
  set(gca,'fontsize',14)
  xlabel('Normalized frequency (-)')
  ylabel('Normalized receptance (dB)')
end



