%
% Plot the experimental FRF of a piezoelectric beam controlled by a digital
% vibration absorber
%
%
% (c) G. Raze, J. Dietrich and G. Kerschen
% Apr 2022


addpath('Experimental\')

col = get(groot,'defaultAxesColorOrder');
folder = 'Experimental\Results\';

% Files
namesUnmod = {'Unmod_1e-4','Unmod_6-5e-4','Unmod_1e-3','Unmod_1-3e-3'};   % Unmodified admittance
namesMod = {'Mod_1e-4','Mod_6-5e-4','Mod_1e-3','Mod_1-3e-3','Mod_5e-3'};  % Modified admittance


%% Experimental FRF: unmodified, delayed system

figure
hold on
for ii = 1 : length(namesUnmod)
  [fr,h] = TestLabFRFData([folder,namesUnmod{ii}]);
  plot(fr,db(abs(h)./(2*pi*fr.^2)),'-','linewidth',1,'Color',col(ii+1,:))
end
xlim([20 40])
ylim([-90,-40])
box on
set(gca,'fontsize',14)
xlabel('Frequency (Hz)')
ylabel('Magnitude (dB, ref. m/N)')


%% Experimental FRF: modified, delayed system

figure
hold on
for ii = 1 : length(namesMod)
  [fr,h] = TestLabFRFData([folder,namesMod{ii}]);
  if ii < length(namesMod)
    plot(fr,db(abs(h)./(2*pi*fr.^2)),'-','linewidth',1,'Color',col(ii+1,:))
  else
    
    plot(fr,db(abs(h)./(2*pi*fr.^2)),'-','linewidth',1,'Color',col(1,:))
  end
end
xlim([20 40])
ylim([-90,-40])
box on
set(gca,'fontsize',14)
xlabel('Frequency (Hz)')
ylabel('Magnitude (dB, ref. m/N)')