% Theoretical critical values at which the root locus crosses the imaginary
% axis (pure delay model)
%
% (c) G. Raze, J. Dietrich and G. Kerschen
% Apr 2022
% 
% Input:
%   * Kc, effective/generalized electromechanical coupling factor
%
% Output:
%   * tauc: critical delay/sample time
%   * wc: critical frequency (frequency at which the root locus crosses the
%   imaginary axis)
%
function [tauc,wc] = criticalDelays(Kc)

Kc = Kc(:);
  
wc = [sqrt(1 - Kc + 5/8*Kc.^2 - 73/128*Kc.^3) ,... 
      sqrt(1 + Kc.^2/2) ,...
      sqrt(1 + Kc + 5/8*Kc.^2 + 73/128*Kc.^3)];
    
tauc = [sqrt(6)*(Kc+Kc.^2) + 19/32*sqrt(3/2)*Kc.^3 ,... 
      2*pi + sqrt(6)*Kc - pi/2*Kc.^2 - 37/32*sqrt(3/2)*Kc.^3 ,...
      sqrt(6)*(Kc-Kc.^2) + 19/32*sqrt(3/2)*Kc.^3];

end