%
% Half power method to estimate the damping ratio
% 
% Input:
%   * h: FRF around a peak
%   * w: associated frequency vector
%
% Output:
%   * xi: estimated damping ratio
%
% (c) G. Raze, J. Dietrich and G. Kerschen
% Sep 2021
%
function xi = halfPowerDamping(h,w)


  [hMax,ind] = max(abs(h));
  w0 = w(ind);
  
  w1 = interp1(db(abs(h(1:ind))),w(1:ind),db(hMax)-3);
  w2 = interp1(db(abs(h(ind+1:end))),w(ind+1:end),db(hMax)-3);

  xi = double((w2-w1)/(2*w0));
end