% H2 optimization of the damping ratios of multimodal shunts circuits
% Admittance-based approach
%
% See
%
% Fleming, A.J.,Behrens, S. and Moheimani, S.O.R. (2002)
% 'Optimization and implementation of multimode piezoelectric shunt damping
% systems',
% IEEE/ASME Transactions on Mechatronics, 7(1), pp 87-94. doi: 10.1109/3516.990891.
%
% Sep 2021
%
function zeta = dampingAdmittanceOptimization(sys,ri,zi,zetai,Cpe)
    
  zeta = fminunc(@(zetai) admittanceObjFun(sys,ri,zi,zetai,Cpe),zetai,...
    optimoptions(@fminunc,'OptimalityTolerance',1e-9,'StepTolerance',1e-9,...
    'display','none'));


  function f = admittanceObjFun(sys,ri,zi,zetai,Cpe)
    s = zpk(0,[],1);
    Yid = idealAdmittance(ri,zi,zetai,Cpe);
    sysid = feedback(sys,-minreal(Yid/s),2,2);
    f = norm(sysid(1,1));
  end

end