install.packages("Morpho")
install.packages("ggplot2")
install.packages("geomorph")
install.packages("rgl")
install.packages('ggfortify')
install.packages("shapes")
install.packages("ape") 
install.packages("memisc")
install.packages("ggthemes")
install.packages("ggrepel")
install.packages("dispRity")
install.packages("devtools")

library(ggplot2)
library(grid)
library(geomorph)
library(Morpho)
library(ggfortify)
library(shapes)
library(ape)
library(memisc)
library(plyr)
library(ggthemes) 
library(ggrepel)
library(cluster)
library(dplyr)
library(dispRity)
library(vegan)

setwd("C:/Users/Nari/Desktop/Mmoire/Landmarks")

# # #  Storage of the coordinates in matrix # # # 

# FELINES #
aci_jub <- as.matrix(read.pts("Acinonyx_rhm_MNCN_COMP_3438.pts"))
car_car <- as.matrix(read.pts("Caracal_c_MAV-1518.pts"))
fel_lyb <- as.matrix(read.pts("Felis_l_MAV-965.pts"))
lyn_ruf <- as.matrix(read.pts("Lynx_r_OUVC_9576.pts"))
neo_neb <- as.matrix(read.pts("Neofelis_n_BC-005.pts"))
pan_leo <- as.matrix(read.pts("Panthera_l_c_MNCN COMP-255.pts"))
pan_tig <- as.matrix(read.pts("Panthera_t_c_MNCN COMP-999.pts"))
pan_onc <- as.matrix(read.pts("Panthera_o_c_MAV-2415.pts"))
pan_par <- as.matrix(read.pts("Panthera_p_AMNH_113745.pts"))
pan_unc <- as.matrix(read.pts("Panthera_u_c_BC-56.pts"))
pum_con <- as.matrix(read.pts("Puma_c_ISM_ZOO_693928.pts"))

# PROMEGANTEREON #
# BAT 1 #
B_3109 <- as.matrix(read.pts("Promegantereon_c_B-3109.pts"))
B_5264 <- as.matrix(read.pts("Promegantereon_c_B-5264.pts"))
B_7042 <- as.matrix(read.pts("Promegantereon_c_B-7042.pts"))
BAT_1_02_E7_66 <- as.matrix(read.pts("Promegantereon_c_BAT-102 E7-66.pts"))
BAT_1_07_E5_97 <- as.matrix(read.pts("Promegantereon_c_BAT-107-E5-97.pts"))
BAT_1_07_E5_102 <- as.matrix(read.pts("Promegantereon_c_BAT-1'07 E5-102.pts"))
B_4708 <- as.matrix(read.pts("Promegantereon_rhm_B_4708.pts"))
B_5198 <- as.matrix(read.pts("Promegantereon_rhm_B-5198.pts"))
BAT_1_01_E5_17 <- as.matrix(read.pts("Promegantereon_rhm_BAT-1`01 E5-17.pts"))

# BAT 3 #
BAT_3_11_2339 <- as.matrix(read.pts("Promegantereon_c_BAT_3_11_2339.pts"))
BAT_3_05_D8_755 <- as.matrix(read.pts("Promegantereon_c_BAT-305 D8-755.pts"))
BAT_3_09_779 <- as.matrix(read.pts("Promegantereon_c_BAT-309 779.pts"))
BAT_3_10_1773 <- as.matrix(read.pts("Promegantereon_c_BAT-310-1773.pts"))
BAT_3_1_2020 <- as.matrix(read.pts("Promegantereon_c_BAT-311-2020.pts"))
BAT_3_14_94 <- as.matrix(read.pts("Promegantereon_lhm_BAT-314-94.pts"))
BAT_3_11_132 <- as.matrix(read.pts("Promegantereon_rhm_BAT-3`11 132.pts"))
BAT_3_13_1596 <- as.matrix(read.pts("Promegantereon_rhm_BAT-313-1596.pts"))

# MACHAIRODUS #
# BAT 1 #
B_2230 <- as.matrix(read.pts("Machairodus_c_B 2230.pts"))
BAT_1_04_F6_130 <- as.matrix(read.pts("Machairodus_c_BAT-104 F6-130.pts"))
BAT_1_05_E6_42 <- as.matrix(read.pts("Machairodus_c_BAT-105 E6-42.pts"))
BAT_1_05_F6_265 <- as.matrix(read.pts("Machairodus_c_BAT-105 F6-265.pts"))
BAT_1_01_E7_82 <- as.matrix(read.pts("Machairodus_lhm_BAT-1`01 E7-82.pts"))
BAT_1_06_E4_52 <- as.matrix(read.pts("Machairodus_lhm_BAT-1`06 E4-52.pts"))
B_382 <- as.matrix(read.pts("Machairodus_rhm_B-382.pts"))
B_3974 <- as.matrix(read.pts("Machairodus_rhm_B-3974.pts"))

# BAT 3 #
BAT_3_07_698 <- as.matrix(read.pts("Machairodus_c_BAT-307 698.pts"))
BAT_3_09_1344 <- as.matrix(read.pts("Machairodus_c_BAT-309 1344.pts"))
BAT_3_13_1916b <- as.matrix(read.pts("Machairodus_c_BAT-313 1916b.pts"))
BAT_3_13_1017 <- as.matrix(read.pts("Machairodus_c_BAT-3'09 1017.pts"))
BAT_3_07_672 <- as.matrix(read.pts("Machairodus_lhm_BAT-307 672.pts"))

# OTHER MACHAIRODONTS #
smi_fat <- as.matrix(read.pts("Smilodon_F_F_AM_14349_M7786-9732 ASCII.pts"))
xen_hod <- as.matrix(read.pts("Xenosmilus_h_BC_113.pts"))
meg_ind <- as.matrix(read.pts("Megantereon_c_CB_20.pts"))
Amp_gig <- as.matrix(read.pts("Amphimachairodus_G_c_BC-102.pts"))
hom_cre <- as.matrix(read.pts("Homotherium_c_CB-06.pts"))
din_bar <- as.matrix(read.pts("Dinofelis_b_DNMNH_BF_55_23.pts"))


# # # Array # # # 

array_landmarks <- bindArr(aci_jub,
                    car_car,
                    fel_lyb,
                    lyn_ruf,
                    neo_neb,
                    pan_leo,
                    pan_tig,
                    pan_onc,
                    pan_par,
                    pan_unc,
                    pum_con,
                    B_3109,
                    B_5264,
                    B_7042,
                    BAT_1_02_E7_66,
                    BAT_1_07_E5_97,
                    BAT_1_07_E5_102,
                    B_4708,
                    B_5198,
                    BAT_1_01_E5_17,
                    BAT_3_11_2339,
                    BAT_3_05_D8_755,
                    BAT_3_09_779,
                    BAT_3_10_1773,
                    BAT_3_1_2020,
                    BAT_3_14_94,
                    BAT_3_11_132,
                    BAT_3_13_1596,
                    B_2230,
                    BAT_1_04_F6_130,
                    BAT_1_05_E6_42,
                    BAT_1_05_F6_265,
                    BAT_1_01_E7_82,
                    BAT_1_06_E4_52,
                    B_382,
                    B_3974,
                    BAT_3_07_698,
                    BAT_3_09_1344,
                    BAT_3_13_1916b,
                    BAT_3_13_1017,
                    BAT_3_07_672,
                    smi_fat,
                    xen_hod,
                    meg_ind,
                    Amp_gig,
                    hom_cre,
                    din_bar,
                    along=3)

dimnames(array_landmarks)[[3]] <-c("Acinonyx_rhm_MNCN_COMP_3438",
                                   "Caracal_c_MAV-1518",
                                   "Felis_l_MAV-965",
                                   "Lynx_r_OUVC_9576",
                                   "Neofelis_n_BC-005",
                                   "Panthera_l_c_MNCN COMP-255",
                                   "Panthera_t_c_MNCN COMP-999",
                                   "Panthera_o_c_MAV-2415",
                                   "Panthera_p_AMNH_113745",
                                   "Panthera_u_c_BC-56",
                                   "Puma_c_ISM_ZOO_693928",
                                   "Promegantereon_c_B_3109",
                                   "Promegantereon_c_B_5264",
                                   "Promegantereon_c_B_7042",
                                   "Promegantereon_c_BAT-1_02_E7_66",
                                   "Promegantereon_c_BAT-1_07_E5_97",
                                   "Promegantereon_c_BAT-1'07_E5-102",
                                   "Promegantereon_rhm_B_4708",
                                   "Promegantereon_rhm_B_5198",
                                   "Promegantereon_rhm_BAT_1_01_E5_17",
                                   "Promegantereon_c_BAT_3_11_2339",
                                   "Promegantereon_c_BAT-3_05_D8_755",
                                   "Promegantereon_c_BAT-3_09_779",
                                   "Promegantereon_c_BAT-3_10_1773",
                                   "Promegantereon_c_BAT-3_11_2020",
                                   "Promegantereon_lhm_BAT_3_14_94",
                                   "Promegantereon_rhm_BAT_3_11_132",
                                   "Promegantereon_rhm_BAT_3_13_1596",
                                   "Machairodus_c_B_2230",
                                   "Machairodus_c_BAT_1_04_F6_130",
                                   "Machairodus_c_BAT_1_05_E6_42",
                                   "Machairodus_c_BAT_1_05_F6_265",
                                   "Machairodus_lhm_BAT-1_01_E7_82",
                                   "Machairodus_lhm_BAT_1_06_E4_52",
                                   "Machairodus_rhm_B_382",
                                   "Machairodus_rhm_B_3974",
                                   "Machairodus_c_BAT_3_07_698",
                                   "Machairodus_c_BAT_3_09_1344",
                                   "Machairodus_c_BAT_3_13_1916b",
                                   "Machairodus_c_BAT_3_09_1017",
                                   "Machairodus_lhm_BAT_3_07_672",
                                   "Smilodon_F_F_AM_14349_M7786_9732_ASCII",
                                   "Xenosmilus_h_BC_113",
                                   "Megantereon_c_CB_20",
                                   "Amphimachairodus_G_c_BC_102",
                                   "Homotherium_c_CB_06",
                                   "Dinofelis_b_DNMNH_BF_55_23")

# # # Species names # # # 

labels_species <- c("Ac. jubatus",
            "C. caracal",
            "F.lybica",
            "L. rufus",
            "N. nebulosa",
            "Pa. leo",
            "Pa. tigris",
            "Pa. onca",
            "Pa. pardus",
            "Pa. uncia",
            "Pu. concolor",
            " ", #"Pr. ogygia B_3109"
            " ", # "Pr. ogygia B_5264",
            " ",  # "Pr. ogygia B_7042",
            " ", # "Pr. ogygia BAT_1_02_E7_66",
            " ", # "Pr. ogygia BAT_1_07_E5_97",
            " ", # "Pr. ogygia  BAT_1_07_E5_102",
            " ", # "Pr. ogygia B_4708",
            " ", # "Pr. ogygia B_5198",
            " ", # "Pr. ogygia BAT_1_01_E5_17",
            " ", # "Pr. ogygia BAT_3_11_2339",
            " ", # "Pr. ogygia BAT_3_05_D8_755",
            " ", # "Pr. ogygia BAT_3_09_779",
            " ", # "Pr. ogygia BAT_3_10_1773",
            " ", # "Pr. ogygia BAT_3_1_2020",
            " ", # "Pr. ogygia BAT_3_14_94",
            " ", # "Pr. ogygia BAT_3_11_132",
            " ", # "Pr. ogygia BAT_3_13_1596",
            " ",# "Ma. aphanistus B_2230",
            " ",# "Ma. aphanistus BAT_1_04_F6_130",
            " ",# "Ma. aphanistus BAT_1_05_E6_42",
            " ",# "Ma. aphanistus BAT_1_05_F6_265",
            " ",# "Ma. aphanistus BAT_1_01_E7_82",
            " ",# "Ma. aphanistus BAT_1_06_E4_52",
            " ",# "Ma. aphanistus B_382",
            " ",# "Ma. aphanistus B_3974",
            " ",# "Ma. aphanistus BAT_3_07_698",
            " ",# "Ma. aphanistus BAT_3_09_1344",
            " ",# "Ma. aphanistus BAT_3_13_1916b",
            " ",# "Ma. aphanistus BAT_3_13_1017",
            " ",# "Ma. aphanistus BAT_3_07_672",
            "S. fatalis", 
            "X. hodsonae", 
            "Me. sp. indet", 
            "Am. giganteus", 
            "H. crenatidens",
            "D. barlowi")

# # #  Procrustes surimposition including sliding of semi-landmarks on curves # # # 
# Define semi landmarks
semilandmarks <- define.sliders(array_landmarks, nsliders= 24, write.file= FALSE)
# Superimposition
procrust <- gpagen(array_landmarks, curves = semilandmarks)
procrust_pro_mac <- gpagen(array_landmarks[,,12:41], curves = semilandmarks)

# # # PCA # # # 

# Convert coordinates to two-dimensional matrix
coords2d <- two.d.array(procrust$coords)
coords2d_pro_mac <- two.d.array(procrust_pro_mac$coords)

# Calculate consensus and flatten to single vectors
consensus <- apply(procrust$coords, c(1,2), mean)
consensusvec <- apply(coords2d, 2, mean)

consensus_pro_mac <- apply(procrust_pro_mac$coords, c(1,2), mean)
consensusvecpro_mac <- apply(coords2d_pro_mac, 2, mean)

#Calculate Procrustes residuals (Procrustes coordinates - consensus)
resids <- t(t(coords2d)-consensusvec)
resids_pro_mac <- t(t(coords2d_pro_mac)-consensusvec)

#Calculate covariance matrix
P <- cov(resids)
P_pro_mac <- cov(resids_pro_mac)

#Calculate eigenvector and eigenvalues with SVD
pca.stuff <- svd(P)
eigenvalues <- pca.stuff$d
eigenvectors <- pca.stuff$u

pca.stuff_pro_mac <- svd(P_pro_mac)
eigenvalues_pro_mac <- pca.stuff_pro_mac$d
eigenvectors_pro_mac <- pca.stuff_pro_mac$u

#Calculate PCA scores

scores <- resids%*%eigenvectors
scores_pro_mac <- resids_pro_mac%*%eigenvectors_pro_mac

# plotacp <- plot(scores[,1:2],asp=1, pch=20,cex=2)
# plotacp <- plot(scores_pro_mac[,1:2],asp=1, pch=20,cex=2)
# text(scores,labels=labels_species)

# # # Define group based on species/site # # # 

group_species <- c("Feline",
                    "Feline",
                    "Feline",
                    "Feline",
                    "Feline",
                    "Feline",
                    "Feline",
                    "Feline",
                    "Feline",
                    "Feline",
                    "Feline",
                    "Pr_ogygia_BAT1",
                    "Pr_ogygia_BAT1",
                    "Pr_ogygia_BAT1",
                    "Pr_ogygia_BAT1",
                    "Pr_ogygia_BAT1",
                    "Pr_ogygia_BAT1",
                    "Pr_ogygia_BAT1",
                    "Pr_ogygia_BAT1",
                    "Pr_ogygia_BAT1",
                    "Pr_ogygia_BAT1",
                    "Pr_ogygia_BAT3",
                    "Pr_ogygia_BAT3",
                    "Pr_ogygia_BAT3",
                    "Pr_ogygia_BAT3",
                    "Pr_ogygia_BAT3",
                    "Pr_ogygia_BAT3",
                    "Pr_ogygia_BAT3",
                    "Ma_aphanistus_BAT1",
                    "Ma_aphanistus_BAT1",
                    "Ma_aphanistus_BAT1",
                    "Ma_aphanistus_BAT1",
                    "Ma_aphanistus_BAT1",
                    "Ma_aphanistus_BAT1",
                    "Ma_aphanistus_BAT1",
                    "Ma_aphanistus_BAT1",
                    "Ma_aphanistus_BAT3",
                    "Ma_aphanistus_BAT3",
                    "Ma_aphanistus_BAT3",
                    "Ma_aphanistus_BAT3",
                    "Ma_aphanistus_BAT3",
                    "Machairodont", 
                    "Machairodont", 
                    "Machairodont", 
                    "Machairodont", 
                    "Machairodont",
                    "Machairodont")

# Visiualize shape PC + extract % variation explain by PC  

pca.lands <- plotTangentSpace(procrust$coords, label= labels_species, axis1 = 2) ;pca.lands
pca.lands_bis <- plotTangentSpace(procrust_pro_mac$coords, axis1=2); pca.lands_bis

# # # PCA GGPLOT # # # 

# PCA on the whole sample  # 

df_pca <-cbind(as.data.frame(scores[,1:2]),group_species)
df_pca_pro_mac <- cbind(as.data.frame(scores_pro_mac[,1:2]),group_species[12:41])
colnames(df_pca_pro_mac)[3] <- "sp_site"

split(df_pca, df_pca$group_species)
chull.species <- lapply(split(df_pca, df_pca$group_species), function(df){
  df[chull(df),]
})

chull.species <- do.call(rbind, chull.species)
group <- c(chull.species$group_species)  

PCA_final <- ggplot(data=df_pca[,1:2],aes(x=df_pca[,1],y=df_pca[,2],colour=group_species)) +
              theme_minimal() +
              geom_point(size= 3,alpha=0.5) +
              scale_color_manual(values=c("#FF0000", "#1E90FF","#87CEFA", "#FF6F00","#7FFF00", "#458b00")) +
              scale_fill_manual(values=c("#FF0000", "#1E90FF","#87CEFA", "#FF6F00", "#7FFF00", "#458b00")) +
              geom_text_repel(aes(label=labels_species), size=3) +
              labs( x= "PC1 = 46.41%", y= "PC2 = 8.4%") +
              geom_rangeframe(color = "black") +
              geom_polygon(data=chull.species, aes(x=df_pca[,1] , y=df_pca[,2] , fill=group_species), alpha=0.2,color="NA") +
              theme(legend.title = element_blank())

PCA_final

# # # ALLOMETRY # # #

install.packages("ggpubr")
library(ggpubr)

# PC1 vs Centroid size

df_allometry_PC1 <- cbind(group_species,scores[,1],procrust$Csize)

# ggplot 

ggplot(df_allometry_PC1, aes(x=procrust$Csize, y=scores[,1], colour=group_species)) + 
              theme_minimal() +
              geom_point(size= 3,alpha=0.5) +
              geom_smooth(method=lm)+
              geom_rangeframe(color = "black") +
              geom_text_repel(aes(label=labels_species), size=3) +
              labs( x= "Log centroid size", y= "PC1 scores") +
              stat_regline_equation(aes(label =  paste(..eq.label.., ..adj.rr.label.., sep = "~~~~")))


# PC2 vs Centroid size

df_allometry_PC2 <- cbind(scores[,2],procrust$Csize)


# ggplot 


ggplot(df_allometry_PC2, aes(x=procrust$Csize, y=scores[,2])) + 
  geom_point()+
  geom_smooth(method=lm)+
  theme_minimal() +
  geom_rangeframe(color = "black") +
  geom_text_repel(aes(label=labels_species), size=3) +
  labs( x= "Log centroid size", y= "PC2 scores")+
  stat_regline_equation(aes(label =  paste(..eq.label.., ..adj.rr.label.., sep = "~~~~")))

# Table for all PCs

dat=matrix(nrow=46,ncol=2)
dat=data.frame(dat)

df_allometry <- cbind(as.data.frame(scores),procrust$Csize)

for (i in 1:46){
  dat[i,1]<-i
  dat[i,2]<-summary(lm(scores[,i]~procrust$Csize, df_allometry))$adj.r.squared
  }
fix(dat)

write.table(dat, file = "allometry.txt",sep = "\t", row.names = TRUE, col.names = TRUE)

# PCA for Promegantereon and machairodus with centroids # 

split(df_pca_pro_mac, df_pca_pro_mac$sp_site)
chull_pro_mac <- lapply(split(df_pca_pro_mac, df_pca_pro_mac$sp_site), function(df){
  df[chull(df),]
})

chull_pro_mac <- do.call(rbind, chull_pro_mac)

PCA_pro_mac <- ggplot(data=df_pca_pro_mac[,1:2],aes(x=V1,y=V2, colour=df_pca_pro_mac[,3])) +
              theme_minimal() +
              geom_point(size= 3,alpha=0.5) +
              scale_color_manual(values = c("#1E90FF","#87CEFA", "#458b00", "#7FFF00")) +
              scale_fill_manual(values=c("#1E90FF","#87CEFA", "#458b00", "#7FFF00")) +
              labs( x= "PC1 = 19.31%", y= "PC2 = 15.87%") +
              geom_rangeframe(color = "black") +
              geom_polygon(data=chull_pro_mac, aes(x=V1, y=V2, fill=sp_site), alpha=0.2,color="NA") +
              geom_point(aes(x=mean(df_pca_pro_mac[df_pca_pro_mac$sp_site == "Pr_ogygia_BAT1",1]), y=mean(df_pca_pro_mac[df_pca_pro_mac$sp_site == "Pr_ogygia_BAT1" ,2])), shape=3, colour = "#458b00", fill = NA, size = 3) +
              geom_point(aes(x=mean(df_pca_pro_mac[df_pca_pro_mac$sp_site == "Pr_ogygia_BAT3",1]), y=mean(df_pca_pro_mac[df_pca_pro_mac$sp_site == "Pr_ogygia_BAT3" ,2])),  shape=3, colour = "#9ACD32", fill = NA, size = 3) +
              geom_point(aes(x=mean(df_pca_pro_mac[df_pca_pro_mac$sp_site == "Ma_aphanistus_BAT1",1]), y=mean(df_pca_pro_mac[df_pca_pro_mac$sp_site == "Ma_aphanistus_BAT1" ,2])),  shape=3, colour = "#1E90FF", fill = NA, size = 3) +
              geom_point(aes(x=mean(df_pca_pro_mac[df_pca_pro_mac$sp_site == "Ma_aphanistus_BAT3",1]), y=mean(df_pca_pro_mac[df_pca_pro_mac$sp_site == "Ma_aphanistus_BAT3" ,2])),  shape=3, colour = "#1E90FF", fill = NA, size = 3) 
PCA_pro_mac 

# # # ANOVA # # # 

procrust_pro <- gpagen(A = array_landmarks[, , 12:28], curves = semilandmarks) 
gdf_pro <- geomorph.data.frame(procrust_pro, site = as.factor(group_species[12:28]))

procrust_mac <- gpagen(A = array_landmarks[, , 28:41], curves = semilandmarks)
gdf_mac <- geomorph.data.frame(procrust_mac, site = as.factor(group_species[28:41]))

fit1 <- procD.lm(coords~site,data=gdf_pro,iter=999)
fit2 <- procD.lm(coords~site,data=gdf_mac,iter=999)
summary(fit1) ; summary (fit2)


# # # PCOA # # #

setwd("C:/Users/Nari/Desktop/paper")
measurments <- read.csv("Table_morphometry.csv", stringsAsFactors = FALSE)
measurments_pro_mac <- read.csv("Table_morphometry.csv", stringsAsFactors = FALSE)[1:44,]

# keep specimen above the completeness threshold 50%
threshold <- 0.5
measurments <- measurments[apply(!is.na(measurments),1,sum)/dim(measurments)[2]>threshold,] 
measurments_pro_mac <- measurments_pro_mac[apply(!is.na(measurments_pro_mac),1,sum)/dim(measurments_pro_mac)[2]>threshold,] 

# sclae numeric part of the matrix 
measurments[,3:15] <- scale(measurments[,3:15])
measurments_pro_mac[,4:14] <- scale(measurments_pro_mac[,4:14])

#Dissimilarity matrix
gower.dissimilarity.mtrx <- daisy(measurments[,3:15], metric = "gower")
gower <- as.matrix(gower.dissimilarity.mtrx)

gower.dissimilarity.mtrx2 <- daisy(measurments_pro_mac[,4:14], metric = "gower")
gower_pro_mac <- as.matrix(gower.dissimilarity.mtrx2)

# Output most dissimilar pair
measurments[
  which(gower == max(gower[gower != max(gower)]),
        arr.ind = TRUE)[1, ], ]

# Output most similar pair
  measurments[
    which(gower == min(gower[gower != min(gower)]),
          arr.ind = TRUE)[1, ], ]

cluster <- hclust(gower.dissimilarity.mtrx)
plot(cluster, labels=measurments$No)

#Compute PCoA for the whole sample and plot it
pcoa <- pcoa(gower.dissimilarity.mtrx, correction="cailliez")
category <- measurments$CAT
no <- measurments$No
df.pcoa<-cbind(as.data.frame(pcoa$vectors[,1:2]), category, no)

split(df.pcoa, df.pcoa$category)
chull_pcoa <- lapply(split(df.pcoa, df.pcoa$category), function(df){
  df[chull(df),]
})

chull_pcoa <- do.call(rbind, chull_pcoa)

plot_pcoa <- ggplot(data=df.pcoa, aes(x=Axis.1,y=Axis.2, colour=category)) +
              theme_minimal() +
              scale_color_manual(values=c("#FF0000", "#FF6F00","#87CEFA","#1E90FF" , "#458b00", "#7FFF00")) +
              scale_fill_manual(values=c("#FF0000", "#FF6F00","#87CEFA","#1E90FF" , "#458b00", "#7FFF00")) +
              geom_point(size= 3,alpha=0.5) +
              geom_rangeframe(color = "black") +
              geom_text_repel(aes(label=measurments$No), size=3) +
              geom_polygon(data=chull_pcoa, aes(x=Axis.1, y=Axis.2, fill=category), alpha=0.2,color="NA")
plot_pcoa 

# Compute PCoA for Promegantereon & Machairodus and plot it
pcoa_pro_mac <- pcoa(gower_pro_mac, correction="cailliez")
cat <- measurments_pro_mac$CAT
n <- measurments_pro_mac$No
sp <- measurments_pro_mac$Sp
df.pcoa_pro_mac <- cbind(as.data.frame(pcoa_pro_mac$vectors[,1:2]), cat, n)

split(df.pcoa_pro_mac, df.pcoa_pro_mac$cat)
chull_pcoa_pro_mac <- lapply(split(df.pcoa_pro_mac, df.pcoa_pro_mac$cat), function(df){
  df[chull(df),]
})

chull_pcoa_pro_mac <- do.call(rbind, chull_pcoa_pro_mac)

plot_pcoa_pro_mac <- ggplot(data=df.pcoa_pro_mac, aes(x=Axis.1,y=Axis.2, colour=cat)) +
              theme_minimal() +
              scale_color_manual(values = c("#1E90FF","#87CEFA", "#458b00", "#7FFF00")) +
              scale_fill_manual(values=c("#1E90FF","#87CEFA", "#458b00", "#7FFF00")) +
              geom_point(size= 3,alpha=0.75) +
              geom_rangeframe(color = "black") +
              #geom_text_repel(aes(label=measurments_pro_mac$No), size=3) +
              geom_polygon(data=chull_pcoa_pro_mac, aes(x=Axis.1, y=Axis.2, fill=cat), alpha=0.2,color="NA") +
              geom_point(aes(x=mean(df.pcoa_pro_mac[df.pcoa_pro_mac$cat == "PROBAT1",1]), y=mean(df.pcoa_pro_mac[df.pcoa_pro_mac$cat == "PROBAT1" ,2])), shape=3, colour = "#458b00", fill = NA, size = 3) +
              geom_point(aes(x=mean(df.pcoa_pro_mac[df.pcoa_pro_mac$cat == "PROBAT3",1]), y=mean(df.pcoa_pro_mac[df.pcoa_pro_mac$cat == "PROBAT3" ,2])),  shape=3, colour = "#9ACD32", fill = NA, size = 3) +
              geom_point(aes(x=mean(df.pcoa_pro_mac[df.pcoa_pro_mac$cat == "MACBAT1",1]), y=mean(df.pcoa_pro_mac[df.pcoa_pro_mac$cat == "MACBAT1" ,2])),  shape=3, colour = "#1E90FF", fill = NA, size = 3) +
              geom_point(aes(x=mean(df.pcoa_pro_mac[df.pcoa_pro_mac$cat == "MACBAT3",1]), y=mean(df.pcoa_pro_mac[df.pcoa_pro_mac$cat == "MACBAT3" ,2])),  shape=3, colour = "#1E90FF", fill = NA, size = 3)
plot_pcoa_pro_mac

# Obtain influence of each variable on axis 1 & 2 
envfit(pcoa$vectors, measurments[,3:15], na.rm = TRUE)
envfit(pcoa_pro_mac$vectors, measurments_pro_mac[,3:13], na.rm = TRUE)

# # # DISPARITY : MACHAIRODUS  & PROMEGANTEREON : LANDMARKS # # #
array_pro <- array_landmarks[,,12:28]
array_mac <- array_landmarks[,,29:41]

gdf_pro <- geomorph.data.frame(gpagen(array_pro, curves = semilandmarks), species= group_species[12:28]) 
gdf_mac <- geomorph.data.frame(gpagen(array_mac, curves = semilandmarks), species= group_species[29:41])

ord_gdf_pro <- geomorph.ordination(gdf_pro)
ord_gdf_mac <- geomorph.ordination(gdf_mac)

bootstraps_pro <- boot.matrix(ord_gdf_pro,bootstraps = 1000)
bootstraps_mac <- boot.matrix(ord_gdf_mac,bootstraps = 1000)

disp_pro <- dispRity(bootstraps_pro, metric = c(sd, variances))
disp_mac <- dispRity(bootstraps_mac, metric = c(sd, variances))

mat_disp_pro <- matrix(nrow=2000, ncol=2); colnames(mat_disp_pro) <- c("disp","site")
mat_disp_pro[,1] <- c(as.numeric(disp_pro$disparity$species.Pr_ogygia_BAT1[[2]][1,]),as.numeric(disp_pro$disparity$species.Pr_ogygia_BAT3[[2]][1,]))
mat_disp_pro <- data.frame(mat_disp_pro)
mat_disp_pro$site[1:1000] <- "Pr. ogygia BAT1" ; mat_disp_pro$site[1001:2000] <- "Pr. ogygia BAT3"

plot_disp_pro <-  ggplot(data=mat_disp_pro,aes(site,disp))+
                geom_jitter(width=0.2,aes(color=site,alpha=0.5))+
                scale_color_manual(values=c('#458b00','#7FFF00'))+
                geom_boxplot(aes(alpha=0.5),outlier.color = NA)+
                geom_rangeframe(color = "black") +
                labs(title=paste("Disparity in both sites (based on landmarks), \n1000 bootstraps \nWilcoxon test p-value=",signif(test.dispRity(disp_pro,test=wilcox.test)[[2]]$p.value,digits=2)),subtitle = "Alpha = 0.5", y="Disparity",x="")+
                theme_minimal()+
                theme(legend.position = "none", plot.title = element_text(hjust = 0.5), plot.subtitle = element_text(hjust = 0.5))
plot_disp_pro             

mat_disp_mac <- matrix(nrow=2000, ncol=2); colnames(mat_disp_mac) <- c("disp","site")
mat_disp_mac[,1] <- c(as.numeric(disp_mac$disparity$species.Ma_aphanistus_BAT1[[2]][1,]),as.numeric(disp_mac$disparity$species.Ma_aphanistus_BAT3[[2]][1,]))
mat_disp_mac <- data.frame(mat_disp_mac)
mat_disp_mac$site[1:1000] <- "Ma. aphanistus BAT1" ; mat_disp_mac$site[1001:2000] <- "Ma. aphanistus BAT3"

plot_disp_mac <-  ggplot(data=mat_disp_mac,aes(site,disp))+
                  geom_jitter(width=0.2,aes(color=site,alpha=0.5))+
                  scale_color_manual(values=c('#1E90FF','#87CEFA'))+
                  geom_boxplot(aes(alpha=0.5),outlier.color = NA)+
                  geom_rangeframe(color = "black")+
                  labs(title =paste("Disparity in both sites (based on landmarks), \n 1000 bootstraps \nWilcoxon test p-value=",signif(test.dispRity(disp_mac,test=wilcox.test)[[2]]$p.value,digits=2)), subtitle = "Alpha = 0.5" ,y="Disparity",x="")+
                  theme_minimal()+
                  theme(legend.position = "none", plot.title = element_text(hjust = 0.5), plot.subtitle = element_text(hjust = 0.5))
plot_disp_mac 

# # # DISPARITY : MACHAIRODUS  & PROMEGANTEREON : MEASURMENTS # # #

df_pcoa_pro_mac <- cbind(as.data.frame(pcoa_pro_mac$vectors), cat) ; rownames(df_pcoa_pro_mac) <-n
df_pcoa_pro <- df_pcoa_pro_mac[1:25,]
df_pcoa_mac <- df_pcoa_pro_mac[26:39,]
df_pro_mac <- df_pcoa_pro_mac <- cbind(as.data.frame(pcoa_pro_mac$vectors), sp) ; rownames(df_pro_mac) <-n

clades_pro <- list(rownames(df_pcoa_pro)[df_pcoa_pro$cat %in% "PROBAT1"],rownames(df_pcoa_pro)[df_pcoa_pro$cat %in% "PROBAT3"]);names(clades_pro) <- c("PROBAT1","PROBAT3")
clades_mac <- list(rownames(df_pcoa_mac)[df_pcoa_mac$cat %in% "MACBAT1"],rownames(df_pcoa_mac)[df_pcoa_mac$cat %in% "MACBAT3"]);names(clades_mac) <- c("MACBAT1","MACBAT3")
clades_pro_mac <- list(rownames(df_pro_mac)[df_pro_mac$sp %in% "PRO"],rownames(df_pro_mac)[df_pro_mac$sp %in% "MAC"]);names(clades_pro_mac) <- c("PRO","MAC")

sbuset_pro <- custom.subsets(data=data.matrix(df_pcoa_pro, rownames.force = NA),group=clades_pro)
sbuset_mac <- custom.subsets(data=data.matrix(df_pcoa_mac, rownames.force = NA),group=clades_mac)
sbuset_pro_mac <- custom.subsets(data=data.matrix(df_pro_mac, rownames.force = NA),group=clades_pro_mac)

bootstraps_pro_m <- boot.matrix(sbuset_pro,bootstraps = 1000)
bootstraps_mac_m <- boot.matrix(sbuset_mac,bootstraps = 1000)
bootstraps_pro_mac <- boot.matrix(sbuset_pro_mac,bootstraps = 1000)

disp_pro_m <- dispRity(bootstraps_pro_m, metric = c(sd, variances))
disp_mac_m <- dispRity(bootstraps_mac_m, metric = c(sd, variances))
disp_pro_mac <- dispRity(bootstraps_pro_mac, metric = c(sd, variances))

mat_disp_pro_m <- matrix(nrow=2000, ncol=2); colnames(mat_disp_pro_m) <- c("disp","site")
mat_disp_pro_m[,1] <- c(as.numeric(disp_pro_m$disparity$PROBAT1[[2]][1,]),as.numeric(disp_pro_m$disparity$PROBAT3[[2]][1,]))
mat_disp_pro_m <- data.frame(mat_disp_pro_m)
mat_disp_pro_m$site[1:1000] <- "Pr. ogygia BAT1" ; mat_disp_pro_m$site[1001:2000] <- "Pr. ogygia BAT3"

plot_disp_pro <-  ggplot(data=mat_disp_pro_m,aes(site,disp))+
                  geom_jitter(width=0.2,aes(color=site,alpha=0.5))+
                  scale_color_manual(values=c('#458b00','#7FFF00'))+
                  geom_boxplot(aes(alpha=0.5),outlier.color = NA)+
                  geom_rangeframe(color = "black") +
                  labs(title=paste("Disparity in both sites (based on measurments), \n1000 bootstraps \nWilcoxon test p-value=",signif(test.dispRity(disp_pro_m,test=wilcox.test)[[2]]$p.value,digits=2)),subtitle = "Alpha = 0.5", y="Disparity",x="")+
                  theme_minimal()+
                  theme(legend.position = "none", plot.title = element_text(hjust = 0.5), plot.subtitle = element_text(hjust = 0.5))
plot_disp_pro             

mat_disp_mac_m <- matrix(nrow=2000, ncol=2); colnames(mat_disp_mac_m) <- c("disp","site")
mat_disp_mac_m[,1] <- c(as.numeric(disp_mac_m$disparity$MACBAT1[[2]][1,]),as.numeric(disp_mac_m$disparity$MACBAT3[[2]][1,]))
mat_disp_mac_m <- data.frame(mat_disp_mac_m)
mat_disp_mac_m$site[1:1000] <- "Ma. aphanistus BAT1" ; mat_disp_mac_m$site[1001:2000] <- "Ma. aphanistus BAT3"

plot_disp_mac <-  ggplot(data=mat_disp_mac_m,aes(site,disp))+
                  geom_jitter(width=0.2,aes(color=site,alpha=0.5))+
                  scale_color_manual(values=c('#1E90FF','#87CEFA'))+
                  geom_boxplot(aes(alpha=0.5),outlier.color = NA)+
                  geom_rangeframe(color = "black")+
                  labs(title =paste("Disparity in both sites (based on measurments), \n 1000 bootstraps \nWilcoxon test p-value=",signif(test.dispRity(disp_mac_m,test=wilcox.test)[[2]]$p.value,digits=2)), subtitle = "Alpha = 0.5" ,y="Disparity",x="")+
                  theme_minimal()+
                  theme(legend.position = "none", plot.title = element_text(hjust = 0.5), plot.subtitle = element_text(hjust = 0.5))
plot_disp_mac 

mat_disp_pro_mac <- matrix(nrow=2000, ncol=2); colnames(mat_disp_pro_mac) <- c("disp","sp")
mat_disp_pro_mac[,1] <- c(as.numeric(disp_pro_mac$disparity$PRO[[2]][1,]),as.numeric(disp_pro_mac$disparity$MAC[[2]][1,]))
mat_disp_pro_mac <- data.frame(mat_disp_pro_mac)
mat_disp_pro_mac$sp[1:1000] <- "Pr. ogygia" ; mat_disp_pro_mac$sp[1001:2000] <- "Ma. aphanistus"

plot_disp_pro_mac <-  ggplot(data=mat_disp_pro_mac,aes(sp,disp))+
                  geom_jitter(width=0.2,aes(color=sp,alpha=0.5))+
                  scale_color_manual(values=c('#458b00','#1E90FF'))+
                  geom_boxplot(aes(alpha=0.5),outlier.color = NA)+
                  geom_rangeframe(color = "black")+
                  labs(title =paste("Disparity in both sites (based on measurments), \n 1000 bootstraps \nWilcoxon test p-value=",signif(test.dispRity(disp_pro_mac,test=wilcox.test)[[2]]$p.value,digits=2)), subtitle = "Alpha = 0.5" ,y="Disparity",x="")+
                  theme_minimal()+
                  theme(legend.position = "none", plot.title = element_text(hjust = 0.5), plot.subtitle = element_text(hjust = 0.5))
plot_disp_pro_mac 


# # # # # # # # # # # #
# # # # # # # # # # # #
# # # # # # # # # # # #

install.packages("raster")
library(raster)

setwd("C:/Users/Nari/Desktop/Mmoire/Landmarks/Calcul erreur")

error <- as.matrix(read.pts("Promegantereon_c_BAT-107-E5-102.pts"))
errorbis <- as.matrix(read.pts("Promegantereon_c_BAT-107-E5-102_bis.pts"))
errorbis2 <- as.matrix(read.pts("Promegantereon_c_BAT-1'07 E5-102 bis 2.pts"))
errorbis3 <- as.matrix(read.pts("Promegantereon_c_BAT-1'07 E5-102 bis 3.pts"))
errorbis4 <- as.matrix(read.pts("Promegantereon_c_BAT-1'07 E5-102 bis 4.pts"))
errorbis5 <- as.matrix(read.pts("Promegantereon_c_BAT-1'07 E5-102 bis 5.pts"))

arrayerror <- bindArr(error,
                      errorbis,
                      errorbis2,
                      errorbis3,
                      errorbis4,
                      errorbis5,
                      along = 3)

round(apply(arrayerror, c(1,2), sd),3)
round(apply(array_landmarks[,,12:25], c(1,2), sd),3)

nonsimplified <- as.matrix(read.pts("Promegantereon_rhm_BAT-313-1596 NT.pts"))
simplified <- as.matrix(read.pts("Promegantereon_rhm_BAT-313-1596.pts"))

arraysimply <- bindArr(nonsimplified,
                      simplified,
                      along = 3)

round(apply(arraysimply, c(1,2), sd),3)

B2376 <- read.csv("Pr_ogygia_B_2376.csv", sep=";", dec = ",")
B3974 <- read.csv("Ma_aphanistus_B_3974.csv", sep=";", dec = ",")

round(apply(B2376, c(1,2), sd),3)
round(apply(B3974, c(1,2), sd),3)


