% System parameters
k = 1; % Stiffness
c = 1; % Damping
m = 1; % Mass
k3 = 1; % Cubic stiffness

%% Manifold
% Defining a grid of frequencies and amplitudes
Nom = 101;
NX = 101;
[om,X] = meshgrid(linspace(1,6,Nom),linspace(0,7,NX));

% Analytical solution for the excitation amplitude
Fs = k*X - m*X.*om.^2 + k3*3/4*X.^3; % Sine component
Fc = c*X.*om; % Cosine component
F = sqrt(Fs.^2 + Fc.^2); % Force amplitude
phi = atan2(Fs,Fc) - atan2(1,0); % Phase lag

% Unstable region with local negative stiffness
unstable = (F(2:end-1,:) > F(3:end,:)) | (F(2:end-1,:) < F(1:end-2,:));
unstable = [zeros(1,size(unstable,2));unstable;zeros(1,size(unstable,2))];
bound1 = [];
Ubound2 = [];
Dbound2 = [];
for i = 1:Nom
    % Finding indices of the unstable region boundary
    Dfound = find(unstable(i,:)==1,1,'first');
    Ufound = find(unstable(i,:)==1,1,'last');
    Dbound2 = [Dbound2,Dfound];
    Ubound2 = [Ubound2,Ufound];
    if ~isempty(Dfound)
        bound1 = [bound1,i];
    end
end
for i = 1:length(bound1)
    % Corresponding values for the frequency, force and displacement of the
    % unstable region boundary
    omUbound(i) = om(bound1(i),Ubound2(i));
    FUbound(i) = F(bound1(i),Ubound2(i));
    XUbound(i) = X(bound1(i),Ubound2(i));
    omDbound(i) = om(bound1(i),Dbound2(i));
    FDbound(i) = F(bound1(i),Dbound2(i));
    XDbound(i) = X(bound1(i),Dbound2(i));
end
% Unstable region boundary
ombound = [fliplr(omUbound),omDbound];
Fbound = [fliplr(FUbound),FDbound];
Xbound = [fliplr(XUbound),XDbound];

%% Frequency response curves
figure; hold on;
frfF = [4,14,24]; % Force levels
frf = repmat(struct('om',[],'X',[],'F',[]),length(frfF),1);
frfc = contourc(om(1,:),X(:,1),F,frfF);
frfn = zeros(length(frfF),1);
frfbif = zeros(2,length(frfF));
colors = get(gca,'colororder');
% Display stable branches in plain lines and unstable branches in dotted
% lines
for i = 1:length(frfF)
    frfn(i+1) = frfn(i)+1 + frfc(2,frfn(i)+1);
    frf(i).om = frfc(1,frfn(i)+2:frfn(i+1));
    frf(i).X = frfc(2,frfn(i)+2:frfn(i+1));
    frf(i).F = repmat(frfF(i),size(frf(i).X));
    if ~isempty(findpeaks(frf(i).om)) % There is an unstable branch
        [~,frfbif(1,i)] = findpeaks(frf(i).om);
        [~,frfbif(2,i)] = findpeaks(-frf(i).om);
        idx1 = 1:frfbif(1,i);
        idx2 = frfbif(1,i):frfbif(2,i);
        idx3 = frfbif(2,i):length(frf(i).om);
        plot3(frf(i).om(idx1),repmat(frfF(i),size(idx1)),frf(i).X(idx1),...
            '-','Color',colors(i,:),'LineWidth',2);
        plot3(frf(i).om(idx2),repmat(frfF(i),size(idx2)),frf(i).X(idx2),...
            ':','Color',colors(i,:),'LineWidth',2);
        plot3(frf(i).om(idx3),repmat(frfF(i),size(idx3)),frf(i).X(idx3),...
            '-','Color',colors(i,:),'LineWidth',2);
    else % There is no unstable branch
        plot3(frf(i).om,repmat(frfF(i),size(frf(i).om)),frf(i).X,...
            '-','Color',colors(i,:),'LineWidth',2);
    end
end
%% S-curves
scurveom = [2,3,4]; % Frequency levels
scurve = repmat(struct('F',[],'X',[]),length(scurveom),1);
scurvebif = zeros(2,length(scurveom));
for i = 1:length(scurveom)
    scurve(i).F = interp2(om,X,F,scurveom(i),X(:,1));
    scurve(i).X = X(:,1);
    scurve(i).om = repmat(scurveom(i),size(scurve(i).X));
    % Alternative means of checking whether there is an unstable branch
    try % There is an unstable branch
        [~,scurvebif(1,i)] = findpeaks(scurve(i).F);
        [~,scurvebif(2,i)] = findpeaks(-scurve(i).F);
    catch % There is no unstable branch
        scurvebif(:,i) = [1;1];
    end
    idx1 = 1:scurvebif(1,i);
    idx2 = scurvebif(1,i):scurvebif(2,i);
    idx3 = scurvebif(2,i):length(scurve(i).F);
    plot3(repmat(scurveom(i),size(idx1)),scurve(i).F(idx1),scurve(i).X(idx1),...
        '-','Color',colors(i+3,:),'LineWidth',2);
    plot3(repmat(scurveom(i),size(idx2)),scurve(i).F(idx2),scurve(i).X(idx2),...
        ':','Color',colors(i+3,:),'LineWidth',2);
    plot3(repmat(scurveom(i),size(idx3)),scurve(i).F(idx3),scurve(i).X(idx3),...
        '-','Color',colors(i+3,:),'LineWidth',2);
end
% Display the manifold
surf(om,F,X,'FaceColor',[.5,.5,.5],'EdgeColor','none','FaceAlpha',0.5)
manifold_light = camlight;
manifold_light.Position = [0,0,4];
% Display the unstable region boundary
plot3(ombound,Fbound,Xbound,'--','Color','white','LineWidth',2);
ylim([0,35]);
xlim([1,6]);
view(30,30);
box on;
title('Figures 1, 2, 3a');
xlabel('\omega');
ylabel('p');
zlabel('x');
