% Continuous model
sys = sys_s;

% Identifying the natural frequency and damping ratio for each pole
m = zeros(n_modes,1);
xsiom2 = zeros(n_modes,1); % Damping ratio
omsq = zeros(n_modes,1); % Natural frequency
amp = zeros(n_modes,1); % Amplitude
amp_mono = zeros(n_modes); % Amplitude of single pole
for i = 1:n_modes
    pole = poles_s(i);
    sys_mono(i) = zpk([],[pole,conj(pole)],1);
    [num,den] = tfdata(sys_mono(i));
    [amp(i),~] = bode(sys,imag(pole));
    xsiom2(i) = den{1}(2);
    omsq(i) = den{1}(3);
end

% Computing the amplitude of the single poles
for i = 1:n_modes
    for j = 1:n_modes
        [amp_mono(i,j),~] = bode(sys_mono(j),imag(poles_s(i)));
    end
end
gain = (amp_mono\amp);
% Computing the modal masses to fit the resonance peaks
for i = 1:length(gain)
    m(i) = shape(2,i).'*shape(2,i)/gain(i);
end
% Modal damping
c = xsiom2.*m;
% Modal stiffness
k = omsq.*m;

% Mass-spring-damper model
sys_mck = tf(0,1);
for i = 1:n_modes
    sys_mck = sys_mck + tf(shape(2,i).'*shape(2,i),[m(i),c(i),k(i)]);
end

% Spatial mass matrix
M = inv(shape).'*diag(m)*inv(shape);
% Spatial damping matrix
C = inv(shape).'*diag(c)*inv(shape);
% Spatial stiffness matrix
K = inv(shape).'*diag(k)*inv(shape);