% Approximate resonance frequencies
chosenz = [8.93,55.61,146.5,197.9,292.5]*2*pi;
chosenp = [6.169,31.89,78.29,170.9,255.3,304.5]*2*pi;

% Dimension of the model
n_modes = 6;
% Set the amplitude of the model equal to the nth pole
amp_idx = 3;

% Choosing poles closest to approx. resonances
diffz = abs(omegaz-chosenz);
diffp = abs(omegap-chosenp);
[~,idxp] = min(diffp,[],1);
[~,idxz] = min(diffz,[],1);

sys_poles = [poles(idxp);conj(poles(idxp))];
sys_zeros = [zer(idxz);conj(zer(idxz))];

% Moving unstable poles to the left-hand half-plane
uns_poles = real(log(sys_poles)) > 0;
uns_zeros = real(log(sys_zeros)) > 0;
sys_poles(uns_poles) = exp(-conj(log(sys_poles(uns_poles))));
sys_zeros(uns_zeros) = exp(-conj(log(sys_zeros(uns_zeros))));

% Discrete model
sys = zpk(sys_zeros,sys_poles,1,deltat);

% Checking the amplitude of the nth pole
amp_FRF = abs(FRF(find(omega>chosenp(amp_idx),1,'first')));
[amp_sys,~] = bode(sys,imag(log(sys_poles(amp_idx))/deltat));

% Scaling the model
sys = zpk(sys_zeros,sys_poles,amp_FRF/amp_sys,deltat);

% Continuous model
zeros_s = log(sys_zeros)/deltat;
poles_s = log(sys_poles)/deltat;
sys_s = zpk(zeros_s,poles_s,1);
[amp_s,~] = bode(sys_s,imag(poles_s(3)));
sys_s = zpk(zeros_s,poles_s,amp_FRF/amp_s);