freq1 = 1;
freq2 = 1000;

% Indices of relevant frequencies
idx1 = find(freq > freq1,1,'first');
idx2 = find(freq < freq2,1,'last');
omega = freq(idx1:idx2)*2*pi;
FRF = FRF_av(idx1:idx2);
% Weighing factor
W = 1./sqrt(variance(idx1:idx2).');
% Sampling time
deltat = 1e-4;

warning('off','all');

% Polymax method
% Fitting 1000 poles
p = 1000;
X = W.*exp(1i*omega.'*deltat.*(0:p));
Y = -X.*FRF.';
R = real(X'*X);
S = real(X'*Y);
T = real(Y'*Y);
M = 2*(T - S.'*(R\S));

alphah = M(1:p,1:p)\-M(1:p,p+1);
alpha = [alphah;1];
beta = -R\S*alpha;

alpha = fliplr(alpha.');
beta = fliplr(beta.');

poles = roots(alpha);    
zer = roots(beta);
omegap = imag(log(poles))/deltat;
omegaz = imag(log(zer))/deltat;

warning('on','all');
