figure;
hold on;

% Frequency sweep
load('./sweep_lin_0_5.mat');
file = sweep_lin_0_5_mat_saving1;
disp = dspace_data(file,'disp');
freq = dspace_data(file,'freq');
plot(freq,disp);

% Characterization via CBC
load('./manifold_lin_steps.mat');
data = manifold_lin_steps;
% Import the manifold
import_manifold;
force_levels = 0.5;
% Extract the FRC from the manifold
interpolate_manifold;
plot(frc_out{1}(1,:),frc_out{1}(2,:),'LineWidth',2,'Color',[0.9290,0.6940,0.1250]);

xlim([76 81]);
ylim([0 5e-4]);
xlabel('\omega [Hz]');
ylabel('x [m]');
box on;
title('Figure 9');