% Import data
import_chirp2;
% Identify poles and zeros
polymax;
% Select poles and zeros
pzselection;
% Compute theoretical mode shapes
beam_theory;
% Create mass spring damper system
sys_to_mck;
% Display frequency response
% Coefficient between shaker's voltage and force = 160 N/V
figure;
[mag,~,wout] = bode(sys_mck);
loglog(wout/2/pi,squeeze(mag)/160,'LineWidth',2);
hold on;
loglog(freq,abs(FRF_av)/160,'LineWidth',2);
xlim([2,400]);
legend('Model','Data');
xlabel('Frequency [Hz]');
ylabel('Amplitude [m/N]');
title('Figure 8');