% Create the figures
fig_scurve = figure; hold on;
box on;
xlabel('F_f [N]');
ylabel('X_f [m]');
xlim([0 3]);
ylim([1e-4 4e-4]);
title('Figure 11');

fig_conv = figure; hold on;
ax = gca;
ax.YScale = 'log';
ax.XDir = 'reverse';
xlabel('\Delta\phi [rad]');
ylabel('max |F_{nf}| [N]');
title('Figure 12');
box on;

%% Offline CBC
% Import data
load('./manifold_duf_iter.mat');
data = manifold_duf_iter_mat_saving1;
import_manifold;
% indices of interest
id = 6.5e6:6.85e6;
% Compute the phase lag and the invasiveness parameter
performance;

% Display S-curve
figure(fig_scurve);
plot(Ff(id_cont),Xf(id_cont),'LineWidth',2);

% Display invasiveness parameter
figure(fig_conv);
c1 = [0, 0.4470, 0.7410];
plot(dphi(id_step),inv(id_step),'Color',c1);
plot(dphi(id_iter),inv(id_iter),'x','Color',c1); % Corrections
plot(dphi(id_cont),inv(id_cont),'o','Color',c1); % Continuations

%% Stepped CBC
% Import data
load('./manifold_duf_filter.mat');
data = manifold_duf_filter_mat_saving1;
import_manifold;
% Indices of interest
id = 5.034e6:5.214e6;
% Compute the phase lag and the invasiveness parameter
performance;

% Display S-curve
figure(fig_scurve);
plot(Ff(id_cont),Xf(id_cont),'LineWidth',2);

% Display invasiveness parameter
figure(fig_conv);
c2 = [0.8500, 0.3250, 0.0980];
plot(dphi(id_cont),inv(id_cont),'Color',c2);
plot(dphi(id_cont),inv(id_cont),'o','Color',c2); % Continuations

%% Swept CBC
% Import data
load('./manifold_duf_sweep_4em5.mat');
data = manifold_duf_sweep_fast;
import_manifold;
% Indices of interest
id = 3.54e6:3.66e6;
% Compute the phase lag and the invasiveness parameter
performance;

% Display S-curve
figure(fig_scurve);
plot(Ff,Xf,'LineWidth',2);

% Display invasiveness parameter
figure(fig_conv);
c3 = [0.9290, 0.6940, 0.1250];
plot(dphi,inv,'Color',c3);

%% Invasive CBC
% Import data
load('./manifold_duf_inv.mat');
data = manifold_duf_inv;
import_manifold;
% Indices of interest
id = 4.92e6:5.085e6;
% Compute phase lag and invasiveness parameter
performance;

% Display S-curve
figure(fig_scurve);
plot(Ff(id_cont),Xf(id_cont),'LineWidth',2);

% Display invasiveness parameter
figure(fig_conv);
c4 = [0.4940, 0.1840, 0.5560];
plot(dphi(id_cont),inv(id_cont),'Color',c4);
plot(dphi(id_cont),inv(id_cont),'o','Color',c4); % Continuations