% If only one FRC is desired, the 'contour' function needs two elements in
% the level vector
if length(force_levels) == 1
    n_frc_out = 1;
    force_levels = [1,1]*force_levels;
else
    n_frc_out = length(force_levels);
end

% Scaling all dimensions
Xscale = 1/(max(manifold.X)-min(manifold.X));
Fscale = 1/(max(manifold.F)-min(manifold.F));
fscale = 1/(max(manifold.freq)-min(manifold.freq));

X = [manifold.X]'*Xscale;
F = [manifold.F]'*Fscale;
f = [manifold.freq]'*fscale;
% Exclusing NaN values in the data
idx = find(~isnan(X) & ~isnan(F) & ~isnan(f));
X = X(idx);
F = F(idx);
f = f(idx);

% Creating a triangle mesh for the manifold
fig0 = figure;
k = boundary(f,X,0.2);
pv = [f(k),X(k)];
try
    [p,t]=distmesh2d(@dpoly,@huniform,1e-2,[min(f),min(X);max(f),max(X)],pv,pv);
catch
    error('The function ''distmesh2d'' is required (http://persson.berkeley.edu/distmesh/).');
end
freqgrid = p(:,1);
Xgrid = p(:,2);
close(fig0);

% Interpolating the data points with kriging
try
    v = variogram([f,X],F);
catch
    error('The function ''variogram'' is required (https://de.mathworks.com/matlabcentral/fileexchange/20355-experimental-semi-variogram).');
end
fig1 = figure;
try
    [~,~,~,vstruct] = variogramfit(v.distance,v.val,[],[],[],'model','stable');
catch
    error('The function ''variogramfit'' is required (https://de.mathworks.com/matlabcentral/fileexchange/20355-experimental-semi-variogram).');
end
try
    [Zhat,~] = kriging(vstruct,f,X,F,freqgrid,Xgrid);
catch
    error('The function ''kriging'' is required (https://fr.mathworks.com/matlabcentral/fileexchange/29025-ordinary-kriging).');
end
close(fig1);

patch.faces = t;
% Unscale the manifold
patch.vertices = [freqgrid/fscale,Zhat/Fscale,Xgrid/Xscale];

patch_faces = patch.faces;
patch_freq = patch.vertices(:,1);
patch_force = patch.vertices(:,2);
patch_disp = patch.vertices(:,3);

fig2 = figure;
trisurf(patch_faces,patch_freq,patch_force,patch_disp);
close(fig2);
%% Extracting the FRC
fig3 = figure;
[C,H] = tricontour([patch_freq,patch_disp],t,patch_force,force_levels);
close(fig3);
n_frc = length(H);
frc_id = 1;
frc = cell(n_frc,1);
frc_len = zeros(n_frc,1);
for i = 1:n_frc
    frc_len(i) = C(2,frc_id);
    frc{i} = C(1:2,frc_id+1:frc_id+frc_len(i));
    frc_id = frc_id + frc_len(i) + 1;
end
% Remove extraneous contours by selecting only the longest ones
[~,out_id] = sort(frc_len,'descend');
frc_out = frc(out_id(1:n_frc_out));
