sweep = 0; % Is the experiment a sweep?
offline = 0; % Has the experiment corrective iterations?
% Fining relevent signals in data file
for i = 1:length(data.Y)
    if contains(data.Y(i).Path,'disp')
        id_disp = i;
    elseif contains(data.Y(i).Path,'exc_in')
        id_exc_in = i;
    elseif contains(data.Y(i).Path,'cont')
        id_cont = i;
    elseif contains(data.Y(i).Path,'iter')
        id_iter = i;
        offline = 1;
    elseif contains(data.Y(i).Name,'run')
        id_cont = i;
        sweep = 1;
    elseif contains(data.Y(i).Path,'freq')
        id_freq = i;
    end        
end
% Importing signals
time = data.X.Data;
exc_in = data.Y(id_exc_in).Data;
disp = data.Y(id_disp).Data;
freq = data.Y(id_freq).Data;
cont = data.Y(id_cont).Data;
if offline
    iter = data.Y(id_iter).Data;
end
%% Filtering signals
% LMS filter
mu = 10/1e4; % LMS parameter
err = zeros(size(disp)); % Error signal
NH = 6; % Number of harmonics
weightsX = zeros(2*NH-1,length(disp)); % Weights for displacement
weightsF = zeros(2*NH-1,length(disp)); % Weights for force
synth = zeros(size(disp)); % Synthesized signal
omega = freq*2*pi; % Frequency
phi = (0:NH-1)'.*omega.*time; % Instantaneous phase
base = [sin(phi);cos(phi)]; % Base harmonic signals
base = base(2:end,:);
pc = 0; % Progression percentage
fprintf('Displacement:\n% 3d%%',pc);
for i = 1:length(disp)-1
    progr = i/(length(disp)-1)*100;
    if floor(progr) ~= pc
        pc = floor(progr);
        fprintf('\b\b\b\b');
        fprintf('% 3d%%',pc);
    end
    % Filtering...
    synth(i) = sum(weightsX(:,i).*base(:,i));
    err(i) = disp(i)-synth(i);
    weightsX(:,i+1) = weightsX(:,i) + mu*err(i)*base(:,i);
end
fprintf('\n');
fprintf('Force:\n% 3d%%',pc);
for i = 1:length(exc_in)-1
    progr = i/(length(exc_in)-1)*100;
    if floor(progr) ~= pc
        pc = floor(progr);
        fprintf('\b\b\b\b');
        fprintf('% 3d%%',pc);
    end
    % Filtering...
    synth(i) = sum(weightsF(:,i).*base(:,i));
    err(i) = exc_in(i)-synth(i);
    weightsF(:,i+1) = weightsF(:,i) + mu*err(i)*base(:,i);
end
fprintf('\n');
%% Exporting different S-curves
idx_scurve = find(cont==1);
if sweep
    % If experiment is a sweep, only consider data every 1000 time steps
	idx_scurve = idx_scurve(1:floor(length(idx_scurve)/1000):end);
end
phi_1p = (0:NH-1)'.*(0:0.1:2*pi); % Instantaneous phase
% Basis signal to compute peak amplitude
base_1p = [sin(phi_1p);cos(phi_1p)];
base_1p = base_1p([2:end/2,end/2+2:end],:);  % exclude DC
X = zeros(size(idx_scurve));
for i = 1:length(idx_scurve)
    % Peak amplitude
    X(i) = max(sum(weightsX([1:(end-1)/2,(end-1)/2+2:end],idx_scurve(i)).*base_1p,1));
end
% Fundamental amplitude
Xf = sqrt(weightsX(1,idx_scurve).^2+weightsX(1+NH,idx_scurve).^2);
% Fundamental force
F = sqrt(weightsF(1,idx_scurve).^2+weightsF(1+NH,idx_scurve).^2);
% Frequency
f = freq(idx_scurve);

% All points in the manifold
manifold.freq = f;
manifold.F = F;
manifold.X = X;