load('./chirp_free_final.mat');

file = chirp_free_final;
% Displacement id in data file
disp_id = 3;
% Shaker voltage id in data file
input_id = 5;
% Identificator of relevant data
stamp_id = 6;

% Import raw data
n_signal = length(file.Y);
data_raw = zeros(n_signal,length(file.Y(1).Data));
for i = 1:n_signal
    data_raw(i,:) = file.Y(i).Data;
end
time = file.X.Data;
% Index of relevant data
idx = find(data_raw(stamp_id,:) == 1);
lengths = [idx(2:end)-idx(1:end-1), length(time)-idx(end)+1];
max_length = max(lengths);

% Splitting repeated measurements
N = length(idx);
datac = cell(n_signal,N);
for i = 1:n_signal
    for k = 1:N-1
        datac{i,k} = data_raw(i,idx(k):idx(k+1)-1);
    end
    datac{i,N} = data_raw(i,idx(N):end);
end

%Zero-padding
data = zeros(n_signal,max_length,N);
for k = 1:N
    ztail = zeros(1,max_length-lengths(k));
    for i = 1:n_signal
        data(i,:,k) = [datac{i,k},ztail];
    end
end
clear datac;

% Fourier transform
Data = zeros(n_signal,max_length,N);
for i = 1:n_signal
    Data(i,:,:) = fft(data(i,:,:),[],2)/max_length;
end
clear data;

% Frequency responses
FRFs = Data(disp_id,:,:)./Data(input_id,:,:);
% Average of frequency responses
FRF_av = mean(FRFs,3);

variance = var(abs(FRFs),[],3)./abs(FRF_av).^2;
freq = linspace(0,1e4,max_length);