%% S-curves using stepped CBC
load('./manifold_duf_filter.mat');
data = manifold_duf_filter_mat_saving1;
import_manifold;
freqs = unique(manifold.freq);

figure; hold on;
xlabel('\omega [Hz]');
ylabel('f [N]');
zlabel('x [m]');
view([8 12]);
title('Figure 13a');
grid on;
box on;
for i = 1:length(freqs)
    idx = find(manifold.freq==freqs(i));
    plot3(manifold.freq(idx),manifold.F(idx),manifold.X(idx),'.-',...
        'Color',[0, 0.4470, 0.7410]);
end

%% Manifold using stepped CBC
force_levels = 1; % Already extract FRC
interpolate_manifold;
figure;
surf_man = trisurf(patch_faces,patch_freq,patch_force,patch_disp);
surf_man.EdgeColor = 'none';
surf_man.FaceColor = [.5 .5 .5];
xlabel('\omega [Hz]');
ylabel('f [N]');
zlabel('x [m]');
view([8 12]);
grid on;
box on;
title('Figure 13b');
light = camlight();
light.Position = [80 0 5e-4];

%% FRCs
figure;
hold on;

% Frequency sweep up
load('./sweep_duf_up_1.mat');
file = sweep_duf_up_1_mat_saving1;
disp = dspace_data(file,'disp');
freq = dspace_data(file,'freq');
plot(freq,disp);

% Frequency sweep down
load('./sweep_duf_down_1.mat');
file = sweep_duf_down_1_mat_saving1;
disp = dspace_data(file,'disp');
freq = dspace_data(file,'freq');
plot(freq,disp);

% FRC using stepped CBC (already computed)
plot(frc_out{1}(1,:),frc_out{1}(2,:),'LineWidth',2,...
    'Color',[0.9290, 0.6940, 0.1250]);

% FRC using offline CBC
load('./manifold_duf_iter.mat');
data = manifold_duf_iter_mat_saving1;
import_manifold;
force_levels = 1;
interpolate_manifold;
plot(frc_out{1}(1,:),frc_out{1}(2,:),'LineWidth',2,...
    'Color',[0.4660, 0.6740, 0.1880]);

% FRC using swept CBC
load('./manifold_duf_sweep_4em5.mat');
data = manifold_duf_sweep_fast;
import_manifold;
force_levels = 1;
interpolate_manifold;
plot(frc_out{1}(1,:),frc_out{1}(2,:),'LineWidth',2,...
    'Color',[0.3010, 0.7450, 0.9330]);

title('Figure 14');
xlabel('\omega [Hz]');
ylabel('x [m]');
xlim([76 85]);
ylim([0 4e-4]);