% Illustrate the convergence with the stepped characterization of the
% hardening-softening-hardening artificial system
load('./manifold_HSH_filter.mat');
tlim = [267.6 268.05];
tol = 2e-7;

disp = manifold_HSH_filter.Y(7).Data; % Displacement
param = manifold_HSH_filter.Y(6).Data; % Convergence parameter
time = manifold_HSH_filter.X.Data; % Time
cont = manifold_HSH_filter.Y(3).Data; % Continuation indicator

% Create figures
fig_disp = figure; hold on;
xlim(tlim);
xlabel('t [s]');
ylabel('x [m]');
ax = gca;
ax.FontSize = 15;
title('Figure 10a');

fig_param = figure; hold on;
xlim(tlim);
xlabel('t [s]');
ylabel('max std(X) [m]');
ax = gca;
ax.FontSize = 15;
title('Figure 10b');

% Draw the grey areas corresponding to the buffer zones
clear patch;
conv_zone = patch([tlim(1),tlim(1),tlim(2),tlim(2)],[tol,0,0,tol],[0,1,0]);
conv_zone.EdgeColor = 'none';
conv_zone.FaceAlpha = 0.5;

idx_time = find(time<tlim(1),1,'last'):find(time>tlim(2),1,'first');
% Find when the convergence parameter changes
idx_param = find(diff(param(idx_time)) ~= 0);
% Find when continuation takes place
idx_cont = find(cont(idx_time) == 1);
% Find when is the first time the convergence parameter changes
iidx_cont = find(idx_param < idx_cont(1),1,'last');
% Find when evaluations of the convergence parameter take place
idx_eval = idx_param(iidx_cont:10:end);
% Find the corresponding buffer regions
idx_buf = idx_param(iidx_cont:5:end);

% Convergence parameter
plot(time,param,'LineWidth',1);
% Negative evaluations of the convergence parameter
plot(time(idx_time(idx_eval)).*[1;1],repmat([0;1.5e-6],size(idx_eval)),...
    '--k','LineWidth',1);
% Positive evaluations of the convergence parameter -> continuation
plot(time(idx_time(idx_cont)).*[1;1],repmat([0;1.5e-6],size(idx_cont)),...
    '-k','LineWidth',1);

figure(fig_disp);
% Draw the buffer zones
buf_zone = patch([tlim(1),time(idx_time(idx_buf([1,1]))),tlim(1)],[5e-4,5e-4,-5e-4,-5e-4],[.5,.5,.5]);
buf_zone.EdgeColor = 'none';
buf_zone.FaceAlpha = 0.2;
for i = 3:2:length(idx_buf)
    buf_zone = patch(time(idx_time(idx_buf([i-1,i,i,i-1]))),[5e-4,5e-4,-5e-4,-5e-4],[.5,.5,.5]);
    buf_zone.EdgeColor = 'none';
    buf_zone.FaceAlpha = 0.2;
end
% Time signal
plot(time,disp,'LineWidth',1);
% Negative evaluations of the convergence parameter
plot(time(idx_time(idx_eval)).*[1;1],repmat([-5e-4;5e-4],size(idx_eval)),...
    '--k','LineWidth',1);
% Positive evaluations of the convergence parameter
plot(time(idx_time(idx_cont)).*[1;1],repmat([-5e-4;5e-4],size(idx_cont)),...
    '-k','LineWidth',1);
