% Number of modes
n_modes = 6;

% Theoretical resonance frequencies
om0 = rand(100,1)*100*2*pi;
om = zeros(length(om0),1);
flag = zeros(length(om0),1);
for i = 1:length(om0)
[om(i),~,flag(i)] = fsolve(@(om)cos(sqrt(om))*cosh(sqrt(om))+1,om0(i),optimoptions('fsolve','Display','off'));
end

idx = find(flag > 0);
om = uniquetol(om(idx),1e-3);

% Theoretical mode shapes
x = linspace(0,1,100);
w = zeros(length(om),length(x));
for i = 1:length(om)
    w(i,:) = sin(sqrt(om(i))*x) - sinh(sqrt(om(i))*x) + ...
        (sin(sqrt(om(i)))+sinh(sqrt(om(i))))/(cos(sqrt(om(i)))+cosh(sqrt(om(i))))*...
        (-cos(sqrt(om(i))*x)+cosh(sqrt(om(i))*x));
    w(i,:) = w(i,:)/max(abs(w(i,:)));
end

shape = interp1(x,w(1:n_modes,:)',1/n_modes:1/n_modes:1);
shape = shape./sqrt(sum(shape.^2,1));