%% Manifold using stepped CBC
load('./manifold_quadamp_filter.mat');
data = manifold_quadamp_filter;
import_manifold;
force_levels = 2; % Already extract FRC
interpolate_manifold;

figure;
surf_man = trisurf(patch_faces,patch_freq,patch_force,patch_disp);
surf_man.EdgeColor = 'none';
surf_man.FaceColor = [.5 .5 .5];
xlabel('\omega [Hz]');
ylabel('f [N]');
zlabel('x [m]');
view([8 12]);
grid on;
box on;
title('Figure 17a');
light = camlight();
light.Position = [80 -2 9e-4];

%% FRCs
figure; hold on;

% Frequency sweep up
load('./sweep_quadamp_up_2.mat');
file = sweep_quadamp_up_2_mat_saving1;
disp = dspace_data(file,'disp');
freq = dspace_data(file,'freq');
plot(freq,disp);

% Frequency sweep down
load('./sweep_quadamp_down_2.mat');
file = sweep_quadamp_down_2_mat_saving1;
disp = dspace_data(file,'disp');
freq = dspace_data(file,'freq');
plot(freq,disp);

% FRC using stepped CBC (already computed)
plot(frc_out{1}(1,:),frc_out{1}(2,:),'LineWidth',2,...
    'Color',[0.9290, 0.6940, 0.1250]);
% FRC using stepped CBC (low amplitude)
force_levels = .7;
interpolate_manifold;
plot(frc_out{1}(1,:),frc_out{1}(2,:),'--','LineWidth',2,...
    'Color',[0.9290, 0.6940, 0.1250]);

% FRC using offline CBC
load('./manifold_quadamp_iter.mat');
data = manifold_quadamp_iter;
import_manifold;
force_levels = 2;
interpolate_manifold;
plot(frc_out{1}(1,:),frc_out{1}(2,:),'LineWidth',2,...
    'Color',[0.4660, 0.6740, 0.1880]);
% FRC using offline CBC (low amplitude)
force_levels = .7;
interpolate_manifold;
plot(frc_out{1}(1,:),frc_out{1}(2,:),'--','LineWidth',2,...
    'Color',[0.4660, 0.6740, 0.1880]);

% FRC using swept CBC
load('./manifold_quadamp_sweep_4em5.mat');
data = manifold_quadamp_sweep_4em5_mat_saving1;
import_manifold;
force_levels = 2;
interpolate_manifold;
plot(frc_out{1}(1,:),frc_out{1}(2,:),'LineWidth',2,...
    'Color',[0.3010, 0.7450, 0.9330]);
% FRC using swept CBC (low amplitude)
force_levels = .7;
interpolate_manifold;
plot(frc_out{1}(1,:),frc_out{1}(2,:),'--','LineWidth',2,...
    'Color',[0.3010, 0.7450, 0.9330]);

title('Figure 17b');
xlabel('\omega [Hz]');
ylabel('x [m]');
xlim([75 85]);
ylim([0 4e-4]);