%% Manifold using stepped CBC
load('./manifold_PWL_filter.mat');
data = manifold_PWL_filter;
import_manifold;
force_levels = .6; % Already extract FRC
interpolate_manifold;

figure;
surf_man = trisurf(patch_faces,patch_freq,patch_force,patch_disp);
surf_man.EdgeColor = 'none';
surf_man.FaceColor = [.5 .5 .5];
xlabel('\omega [Hz]');
ylabel('f [N]');
zlabel('x [m]');
view([8 12]);
grid on;
box on;
title('Figure 16a');
light = camlight();
light.Position = [77 -2 9e-4];

%% FRCs
figure; hold on;

% Frequency sweep up
load('./sweep_PWL_up_0_6.mat');
file = sweep_PWL_up_0_6_mat_saving1;
disp = dspace_data(file,'disp');
freq = dspace_data(file,'freq');
plot(freq,disp);

% Frequency sweep down
load('./sweep_PWL_down_0_6.mat');
file = sweep_PWL_down_0_6_mat_saving1;
disp = dspace_data(file,'disp');
freq = dspace_data(file,'freq');
plot(freq,disp);

% FRC using stepped CBC (already computed)
plot(frc_out{1}(1,:),frc_out{1}(2,:),'LineWidth',2,...
    'Color',[0.9290, 0.6940, 0.1250]);

% FRC using offline CBC
load('./manifold_PWL_iter.mat');
data = manifold_PWL_iter_mat_saving1;
import_manifold;
force_levels = .6;
interpolate_manifold;
plot(frc_out{1}(1,:),frc_out{1}(2,:),'LineWidth',2,...
    'Color',[0.4660, 0.6740, 0.1880]);

% FRC using swept CBC
load('./manifold_PWL_sweep_4em5.mat');
data = manifold_PWL_sweep_4em5;
import_manifold;
force_levels = .6;
interpolate_manifold;
plot(frc_out{1}(1,:),frc_out{1}(2,:),'LineWidth',2,...
    'Color',[0.3010, 0.7450, 0.9330]);

title('Figure 16b');
xlabel('\omega [Hz]');
ylabel('x [m]');
xlim([76 81]);
ylim([0 6e-4]);