% Plots of the experimental results associated with the article
%
% G. Raze , A. Paknejad, G. Zhao, C. Collette and G. Kerschen
% Multimodal vibration damping using a simplified current blocking shunt circuit
% Journal of Intelligent Material Systems and Structures, 31(14), pp.1731-1747
% doi: 10.1177/1045389X20930103
% https://hdl.handle.net/2268/248806
%

%% Data

% Path to the results
expPath = '.\Data\';

% Load frf
[frsc,ysc] = TestLabFRFData([expPath,'SC']);          % Short-circuit FRF
[froc,yoc] = TestLabFRFData([expPath,'OC']);          % Open-circuit FRF
[fr1,y1] = TestLabFRFData([expPath,'ShuntM1']);       % RL shunt on mode 1
[fr2,y2] = TestLabFRFData([expPath,'ShuntM2']);       % RL shunt on mode 2
[frcb1,ycb1] = TestLabFRFData([expPath,'CB_s1e-2']);  % CB shunt, Cf = 1e-2*Cp
[frcb2,ycb2] = TestLabFRFData([expPath,'CB_s1e-1']);  % CB shunt, Cf = 1e-1*Cp
[frcb3,ycb3] = TestLabFRFData([expPath,'CB_s1e+0']);  % CB shunt, Cf = Cp


%% Plots

% Figure settings (size and colors)
pos0 = get(0,'defaultfigureposition');
col = get(groot,'defaultAxesColorOrder');
pos = pos0./[1,1,2,1];

% Shunt on mode 1 - FRFs
figure('Position',pos)
hold on
plot(frsc,db(abs(ysc./((2*pi*frsc).^2))),'-','color',[0.5 0.5 0.5])
plot(froc,db(abs(yoc./((2*pi*froc).^2))),'-k')
plot(fr1,db(abs(y1./((2*pi*fr1).^2))),'-','color',col(1,:))
xlim([25 35])
box on
xlabel('Frequency (Hz)')
ylabel('Magnitude (dB, ref. m/N)')
set(gca,'fontsize',14)


% Shunt on mode 2 - FRFs
figure('Position',pos)
hold on
plot(frsc,db(abs(ysc./((2*pi*frsc).^2))),'-','color',[0.5 0.5 0.5])
plot(froc,db(abs(yoc./((2*pi*froc).^2))),'-k')
plot(fr2,db(abs(y2./((2*pi*fr2).^2))),'-','color',col(1,:))
xlim([130 160])
box on
xlabel('Frequency (Hz)')
ylabel('Magnitude (dB, ref. m/N)')
set(gca,'fontsize',14)


% Shunt on modes 1 and 2 with CB shunts - FRFs
figure()
hold on
plot(froc,db(abs(yoc./((2*pi*froc).^2))),'-k')
plot(frcb1,db(abs(ycb1./((2*pi*frcb1).^2))),'-','color',col(1,:))
plot(frcb2,db(abs(ycb2./((2*pi*frcb2).^2))),'-','color',col(2,:))
plot(frcb3,db(abs(ycb3./((2*pi*frcb3).^2))),'-','color',col(3,:))
xlim([20 180])
box on
xlabel('Frequency (Hz)')
ylabel('Magnitude (dB, ref. m/N)')
set(gca,'fontsize',14)