% Supplementary materials of the article
%
% Raze, G., Jadoul, A., Guichaux, S., Broun, V. and Kerschen, G., 2019. 
% A digital nonlinear piezoelectric tuned vibration absorber. 
% Smart Materials and Structures, 29(1), p.015007.
% doi: 10.1088/1361-665X/ab5176
% https://hdl.handle.net/2268/242115
%
% Plot the linear and nonlinear (at a forcing of 0.2N) FRFs of the
% uncontrolled beam

%% Data
fileSC = './Data/Uncontrolled/FRF_SC';
fileOC = './Data/Uncontrolled/FRF_OC';
file1 = './Data/Uncontrolled/NFRF_Down';
file2 = './Data/Uncontrolled/NFRF_Up';
file3 = './Data/Uncontrolled/NFRF_Up2';


%% Plot

figure
hold on

% Short-circuit FRF
[fr,y] = TestLabFRFData(fileSC);
plot(fr(and(fr>20,fr<40)),abs(y(and(fr>20,fr<40))./(2*pi*fr(and(fr>20,fr<40))).^2),'-','linewidth',2)

% Open-circuit FRF
[fr,y] = TestLabFRFData(fileOC);
plot(fr(and(fr>20,fr<40)),abs(y(and(fr>20,fr<40))./(2*pi*fr(and(fr>20,fr<40))).^2),'-','linewidth',2)

% Short-circuit NFR at 0.2N, sweep down
[fr,y] = TestLabFRFData(file1);
plot(fr,abs(y./(2*pi*fr).^2),'-','linewidth',2)

% Short-circuit NFR at 0.2N, sweep up (NB: the force controller failed after
% the jump down and the measurement had to be restarted)
[fr,y] = TestLabFRFData(file2);
[fr2,y2] = TestLabFRFData(file3);
plot([fr;fr2],abs([y;y2]./(2*pi*[fr;fr2]).^2),'-','linewidth',2)



xlabel('Frequency (Hz)')
ylabel('|x/f| (m/N)')
set(gca,'fontsize',16)
box on
xlim([28 32])
legend('Linear SC','Linear OC','f=0.2N, sweep down','f=0.2N, sweep up','Location','best')