% Supplementary materials of the article
%
% Raze, G., Jadoul, A., Guichaux, S., Broun, V. and Kerschen, G., 2019. 
% A digital nonlinear piezoelectric tuned vibration absorber. 
% Smart Materials and Structures, 29(1), p.015007.
% doi: 10.1088/1361-665X/ab5176
% https://hdl.handle.net/2268/242115
%
% Parametric study for the inductance, resistance and nonlinear capacitance
% (Figures 20-23)

%% Data

% Inductance variation
L_files = {'./Data/Parametric/NL_0-95L_0-2N',...
  './Data/Parametric/NL_1-00L_0-2N',...
  './Data/Parametric/NL_1-05L_0-2N'};

% Resistance variation (0.2N)
R_files = {'./Data/Parametric/NL_0-2N_R0-8',...
  './Data/Parametric/NL_0-2N_R0-9',...
  './Data/Parametric/NL_0-2N_R1-0',...
  './Data/Parametric/NL_0-2N_R1-1'};

% Resistance variation (0.6N)
R_files2 = {'./Data/Parametric/NL_0-6N_R0-8',...
  './Data/Parametric/NL_0-6N_R0-9',...
  './Data/Parametric/NL_0-6N_R1-0',...
  './Data/Parametric/NL_0-6N_R1-1'};

% Nonlinear capacitance variation
Cnl_files = {'./Data/Parametric/Cnl1_FRF',...
  './Data/Parametric/Cnl2_FRF',...
  './Data/Parametric/Cnl3_FRF'};

%% Plots


% Inductance variation
figure
hold on
for ii = 1 : length(L_files)
  dataFile = L_files{ii};
  [fr,y] = TestLabFRFData(dataFile);

  plot(fr,abs(y./(2*pi*fr).^2),'-','linewidth',2)
end
xlim([20 40])
xlabel('Frequency (Hz)')
ylim([0 1.2e-3])
ylabel('|x/f| (m/N)')
set(gca,'fontsize',16)
box on
%legend('0.95L','1.00L','1.05L','location','best')


% Resistance variation (0.2N)
figure
hold on
for ii = 1 : length(R_files)
  dataFile = R_files{ii};
  [fr,y] = TestLabFRFData(dataFile);

  plot(fr,abs(y./(2*pi*fr).^2),'-','linewidth',2)
end
xlim([20 40])
xlabel('Frequency (Hz)')
ylim([0 1.2e-3])
ylabel('|x/f| (m/N)')
set(gca,'fontsize',16)
box on
%legend('0.8R','0.9R','1.0R','1.1R','location','best')


% Resistance variation (0.6N)
figure
hold on
for ii = 1 : length(R_files2)
  dataFile = R_files2{ii};
  [fr,y] = TestLabFRFData(dataFile);

  plot(fr,abs(y./(2*pi*fr).^2),'-','linewidth',2)
end
xlim([20 40])
xlabel('Frequency (Hz)')
ylim([0 1.2e-3])
ylabel('|x/f| (m/N)')
set(gca,'fontsize',16)
box on
%legend('0.8R','0.9R','1.0R','1.1R','location','best')


% Nonlinear capacitance variation
figure
hold on
for ii = 1 : length(Cnl_files)
  dataFile = Cnl_files{ii};
  [fr,y] = TestLabFRFData(dataFile);

  plot(fr,abs(y./(2*pi*fr).^2),'-','linewidth',2)
end
xlim([20 40])
xlabel('Frequency (Hz)')
ylim([0 1.2e-3])
ylabel('|x/f| (m/N)')
set(gca,'fontsize',16)
box on
%legend('C_{nl}','2C_{nl}','3C_{nl}','location','best')