% Supplementary materials of the article
%
% Raze, G., Jadoul, A., Guichaux, S., Broun, V. and Kerschen, G., 2019. 
% A digital nonlinear piezoelectric tuned vibration absorber. 
% Smart Materials and Structures, 29(1), p.015007.
% doi: 10.1088/1361-665X/ab5176
% https://hdl.handle.net/2268/242115
%
% Check the nonlinear impedance of the DNPTVA (Figures 10-12 and 14)

%% Load and resample data
[t,Vin,Vout,VNL] = ArduinoData('.\Data\NL\NL_0-8N_coeff1-8.fig');
AbsorberParameters

% Resample time uniformly
ts = t(1) : (1/1.6e3) : t(end);
qdot = interp1(t,Vout/Ri,ts,'spline');
Vp = interp1(t,Vin/alpha,ts,'spline');
Vnl = interp1(t,VNL/alpha,ts,'spline');

t = ts;

%% Signal processing

% Filter data
bpFilt = designfilt('bandpassiir','DesignMethod','butter',...
         'PassBandFrequency1',5,'PassBandFrequency2',40, ...
         'StopBandFrequency1',2.5,'StopBandFrequency2',60,...
         'StopbandAttenuation1',40, 'StopbandAttenuation2',40,... 
         'SampleRate',1.6e3);       

       
qddot = filtfilt(bpFilt,finiteDerivation(t,qdot));
q = filtfilt(bpFilt,cumtrapz(t,qdot));
qdot = filtfilt(bpFilt,qdot);
Vp = filtfilt(bpFilt,Vp);
Vnl = filtfilt(bpFilt,Vnl);

% Remove initial data
q = q(t>2);
qdot = qdot(t>2);
qddot = qddot(t>2);
Vp = Vp(t>2);
Vnl = Vnl(t>2);
t = t(t>2);

%% Damping curve

[tr,outr] = splineRoots(t,q,[qdot;qddot;Vp]);
Vexp = outr(3,:)-L*outr(2,:);
itmp = linspace(min(outr(1,:)),max(outr(1,:)),2);
figure
hold on
plot(outr(1,:),Vexp,'.k')                   % RFS
plot(itmp,0.9*R*itmp,'-.r','linewidth',2)   % Theoretical damping force (a factor 0.9 was heuristically used on account of the nonlinear dissipation)
xlabel('i (A)')
ylabel('V_p|_{q=di/dt=0} (V)')
set(gca,'fontsize',16)
box on
xlim([min(outr(1,:)),max(outr(1,:))])
ylim([min(Vexp),max(Vexp)])
axis normal


%% NL capacitance curve

[tr2,outr2] = splineRoots(t,qdot,[q;qddot;Vp;filtfilt(bpFilt,q.^3);Vnl]);
[~,ind] = sort(outr2(1,:));
qtmp = linspace(min(outr2(1,:)),max(outr2(1,:)),100);
q3tmp = 3/4*qtmp.^3;
figure
hold on
Vexp2 = outr2(3,:)'-L*outr2(2,:)';
plot(outr2(1,:),Vexp2,'.k')                     % RFS
plot(outr2(1,:),outr2(5,:),'.b')                % Direct measurement of the NL force
plot(qtmp,1.7*Cnl*q3tmp,'-.r','linewidth',2)    % Theoretical NL force (a factor 1.7 was heuristically used on account of the nonlinear piezo capacitance)
xlabel('q (C)')
ylabel('(V_p-L di/dt)|_{i=0} (V)')
xlim([min(outr2(1,:)),max(outr2(1,:))])
ylim([min(4/3*Vexp2),max(4/3*Vexp2)])
axis normal
set(gca,'fontsize',16)
box on

%% Inductance curve

[~,ind2] = sort(outr2(2,:));
ditmp = linspace(min(outr2(2,:)),max(outr2(2,:)),2);
figure
hold on
tmp = outr2(3,:)'-1.7*Cnl*outr2(4,:)';
plot(outr2(2,:),tmp,'.k')
plot(ditmp,L*ditmp,'-.r','linewidth',2)
xlabel('di/dt (A/s)')
ylabel('V_p|_{i=0} (V)')
set(gca,'fontsize',16)
box on



%% RFS
figure
hold on
plot3(q,qdot,Vp-L*qddot,'.k')                                           % RFS
plot3(q,qdot,0.9*R*qdot+1.7*3/4*Cnl*q.^3,'.r')                          % Theoretical law
plot3(0*outr(1,:),outr(1,:),Vexp,'.','Color',0.5*[1,1,1])               % Damping curve
plot3(outr2(1,:),0*outr2(1,:),Vexp2,'.','Color',0.5*[1,1,1])            % NL stiffness curve
xlabel('q')
ylabel('i')
zlabel('V-L*di/dt')
box on
set(gca,'fontsize',16)

% NB: while the damping and stiffness curves match well, there appears to
% be cross-coupling terms that were not noticed when the paper was written.