% Supplementary materials of the article
%
% Raze, G., Jadoul, A., Guichaux, S., Broun, V. and Kerschen, G., 2019. 
% A digital nonlinear piezoelectric tuned vibration absorber. 
% Smart Materials and Structures, 29(1), p.015007.
% doi: 10.1088/1361-665X/ab5176
% https://hdl.handle.net/2268/242115
%
% Plot the nonlinear 'FRFs' of the controlled system (Figures 13, 15 and
% 16)

%% Data

% Data - linear absorber
linear_FRF_files = {...
  './Data/L/0-2N_FRF',...
  './Data/L/0-4N_FRF',...
  './Data/L/0-6N_FRF',...
  './Data/L/0-8N_FRF'};

% Data - nonlinear absorber - moderately nonlinear regime of motion
nonlinear_FRF_files1 = {...
  './Data/NL/0-2N_FRF',...
  './Data/NL/0-4N_FRF',...
  './Data/NL/0-6N_FRF',...
  './Data/NL/0-8N_FRF'};

% Data - nonlinear absorber - strongly nonlinear regime of motion
nonlinear_FRF_files2 = {...
  './Data/NL/0-8N_FRF',...
  './Data/NL/1-0N_FRF',...
  './Data/NL/1-1N_FRF',...
  './Data/NL/1-2N_FRF'};


%% Plots

% LPTVA
figure
hold on
for ii = 1 : length(linear_FRF_files)
  dataFile = linear_FRF_files{ii};
  [fr,y] = TestLabFRFData(dataFile);

  plot(fr,abs(y./(2*pi*fr).^2),'-','linewidth',2)
end
xlim([20 40])
xlabel('Frequency (Hz)')
ylim([0 2e-3])
ylabel('|x/f| (m/N)')
set(gca,'fontsize',16)
box on


% NPTVA - moderately nonlinear regime of motion (0.2 to 0.8 N)
figure
hold on
for ii = 1 : length(nonlinear_FRF_files1)
  dataFile = nonlinear_FRF_files1{ii};
  [fr,y] = TestLabFRFData(dataFile);

  plot(fr,abs(y./(2*pi*fr).^2),'-','linewidth',2)
end
xlim([20 40])
xlabel('Frequency (Hz)')
ylim([0 2e-3])
ylabel('|x/f| (m/N)')
set(gca,'fontsize',16)
box on



% NPTVA - strongly nonlinear regime of motion (0.2 to 0.8 N)
figure
hold on
for ii = 1 : length(nonlinear_FRF_files2)
  dataFile = nonlinear_FRF_files2{ii};
  [fr,y] = TestLabFRFData(dataFile);

  plot(fr,abs(y./(2*pi*fr).^2),'-','linewidth',2)
end
xlim([20 40])
xlabel('Frequency (Hz)')
ylim([0 2e-3])
ylabel('|x/f| (m/N)')
set(gca,'fontsize',16)
box on
