% Retrieve Arduino data from Simulink figure
% 
% Input:
%   * figFile: path to a .fig file for which data is to be extracted
% Output:
%   * t: time
%   * Vin: input signal
%   * Vout: output signal
%   * VNL: nonlinear voltage signal (if it exists)
% 
function [t,Vin,Vout,VNL] = ArduinoData(figFile)
  tt = 1;   % Transient time

  % Open figure
  warning off
  fig = openfig(figFile,'invisible');
  warning on
  t = fig.CurrentAxes.Children(1).XData;

  % Check the number of measurements
  tmpSum = 0;
  for ii = 1 : length(fig.CurrentAxes.Children)
    tmpSum = tmpSum + isa(fig.CurrentAxes.Children(ii),'matlab.graphics.chart.primitive.Stair');
  end
  
  if tmpSum == 3
    VNL = fig.CurrentAxes.Children(1).YData;
    Vout = fig.CurrentAxes.Children(2).YData;
    Vin = fig.CurrentAxes.Children(3).YData;
    
    % Remove transients
    VNL(t<tt) = [];
    Vout(t<tt) = [];
    Vin(t<tt) = [];
  else
    Vout = fig.CurrentAxes.Children(1).YData;
    Vin = fig.CurrentAxes.Children(2).YData;
    VNL = [];
    
    % Remove transients
    Vout(t<tt) = [];
    Vin(t<tt) = [];
  end
  close(fig)

  t(t<tt) = [];
end