% Compute the value of a signal y2 when another signal y vanishes, and the
% instants x where this signal vanishes. x must be strictly increasing.
%
% Input:
%   * x: parametrization vector
%   * y: vanishing signal (vector)
%   * y2: signal of interest (can be a matrix)
% Output:
%   * xr, y2r: x and y2r when y = 0
%
function [xr,y2r] = splineRoots(x,y,y2)

  % Spline interpolation
  pp = spline(x,y);
  
  % Zero crossings
  tr = sign(y(2:end)) ~= sign(y(1:end-1));
  
  xr = zeros(3*sum(tr),1);
  if nargin > 2
    Nd = size(y2,1);
    y2r = zeros(Nd,length(xr));
    pp2 = spline(x,y2);
  end

  nn = 1;
  for ii = 1 : length(tr)
    if tr(ii)
      % Compute the real roots near the zero crossing 
      rr = roots(pp.coefs(ii,:));
      rr = rr(and(and(imag(rr) == 0,real(rr) > 0), real(rr) < x(ii+1)-x(ii)));

      if ~isempty(rr)
        % If real roots have been found, save them
        for jj = 1 : length(rr)
          xr(nn) = x(ii) + rr(jj);
          if nargin > 2
            y2r(:,nn) = pp2.coefs((Nd*(ii-1)+1):(Nd*ii),:)*[rr(jj)^3;rr(jj)^2;rr(jj);1];
          end
          nn = nn + 1;
        end
      end
    end
  end
  
  xr = xr(1:nn-1);
  if nargin > 2
    y2r = y2r(:,1:nn-1);
  end
end